/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.Activity;
import com.bxm.lovelink.common.dal.entity.ActivityOrganizer;
import com.bxm.lovelink.common.dal.entity.ActivityRegistration;
import com.bxm.lovelink.common.dal.entity.ActivityRegistrationData;
import com.bxm.lovelink.common.dal.entity.ActivityType;
import com.bxm.lovelink.common.dal.entity.Region;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.UserOrder;
import com.bxm.lovelink.common.dal.entity.dao.activity.ActivityListDao;
import com.bxm.lovelink.common.dal.entity.dto.activity.ActivityListQueryDto;
import com.bxm.lovelink.common.dal.entity.dto.activity.ActivityQueryDto;
import com.bxm.lovelink.common.dal.entity.vo.activity.ActivityDetailVo;
import com.bxm.lovelink.common.dal.entity.vo.activity.ActivityListVo;
import com.bxm.lovelink.common.dal.entity.vo.activity.GuestRecommendVo;
import com.bxm.lovelink.common.dal.entity.vo.activity.usermutualselection.ActivityUserVo;
import com.bxm.lovelink.common.dal.mapper.ActivityMapper;
import com.bxm.lovelink.common.dal.mapping.activity.ActivityMapping;
import com.bxm.lovelink.common.dal.service.IActivityOrganizerService;
import com.bxm.lovelink.common.dal.service.IActivityRegistrationService;
import com.bxm.lovelink.common.dal.service.IActivityService;
import com.bxm.lovelink.common.dal.service.IActivityTypeService;
import com.bxm.lovelink.common.dal.service.IRegionService;
import com.bxm.lovelink.common.dal.service.IUserBasicInfoService;
import com.bxm.lovelink.common.dal.service.IUserOrderService;
import com.bxm.lovelink.common.dal.service.IUserService;
import com.bxm.lovelink.constant.RedisKeys;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityServiceImpl
extends ServiceImpl<ActivityMapper, Activity>
implements IActivityService {
    private static final Logger log = LoggerFactory.getLogger(ActivityServiceImpl.class);
    private final IActivityTypeService activityTypeService;
    private final IRegionService regionService;
    private final IActivityOrganizerService activityOrganizerService;
    private final IUserBasicInfoService userBasicInfoService;
    private final IUserService userService;
    private final IActivityRegistrationService activityRegistrationService;
    private final RedissonClient redissonClient;
    private final IUserOrderService userOrderService;

    @Override
    public List<ActivityListVo> registeredList(Long userId, ActivityListQueryDto dto) {
        List<ActivityListDao> list = ((ActivityMapper)this.baseMapper).registeredList(userId, dto, LocalDateTime.now());
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<ActivityListVo>();
        }
        return this.fillList(ActivityMapping.INSTANCE.daoToVoList(list));
    }

    @Override
    public Page<ActivityListVo> list(Long userId, ActivityQueryDto dto) {
        dto.setCurrent(Constants.ONE);
        dto.setSize(Integer.MAX_VALUE);
        List activityTypeList = this.activityTypeService.list((Wrapper)new LambdaQueryWrapper().eq(Objects.nonNull(dto.getType()), ActivityType::getType, (Object)dto.getType()));
        if (CollectionUtils.isEmpty((Collection)activityTypeList)) {
            return new Page();
        }
        List<Long> visibleActivityIds = this.getVisibleActivityIds(userId);
        List<Integer> typeIdList = activityTypeList.stream().filter(Objects::nonNull).map(ActivityType::getId).collect(Collectors.toList());
        Page<ActivityListDao> page = ((ActivityMapper)this.baseMapper).list(userId, new Page((long)dto.getCurrent(), (long)dto.getSize()), typeIdList, dto, visibleActivityIds, LocalDateTime.now());
        if (Objects.isNull(page) || CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return new Page();
        }
        Page<ActivityListVo> voPage = ActivityMapping.INSTANCE.daoToVoPage(page);
        if (CollectionUtils.isEmpty((Collection)voPage.getRecords())) {
            return new Page();
        }
        List records = voPage.getRecords();
        this.rebuildActivityListVo(records);
        this.rebuildStatus(records, userId);
        this.reSort(records);
        return voPage;
    }

    private void reSort(List<ActivityListVo> records) {
        for (ActivityListVo record : records) {
            boolean hasRegistered;
            Integer status = record.getStatus();
            boolean bl = hasRegistered = record.getRegisterStatus() == 2;
            int sortStatus = status == 5 ? (hasRegistered ? 1 : 2) : (status == 3 ? 3 : (status == 4 ? (hasRegistered ? 1 : 4) : (status == 1 ? (hasRegistered ? 0 : 4) : 5)));
            record.setSortStatus(sortStatus);
        }
        records.sort(Comparator.comparing(ActivityListVo::getSortStatus).thenComparing(ActivityListVo::getActivityStartTime));
    }

    private void rebuildStatus(List<ActivityListVo> records, Long userId) {
        UserBasicInfo userBasicInfo = this.userBasicInfoService.getOneByUserId(userId);
        if (Objects.isNull(userBasicInfo)) {
            return;
        }
        Integer gender = userBasicInfo.getGender();
        for (ActivityListVo activityListVo : records) {
            Boolean full;
            if (activityListVo.getRegisterEndTime().isBefore(LocalDateTime.now()) && activityListVo.getActivityStartTime().isAfter(LocalDateTime.now())) {
                activityListVo.setStatus(4);
            }
            if (activityListVo.getRegisterStartTime().isAfter(LocalDateTime.now()) || activityListVo.getRegisterEndTime().isBefore(LocalDateTime.now())) continue;
            activityListVo.setStatus(5);
            if (activityListVo.getRegisterStatus().equals(2) || !(full = this.isFull(activityListVo.getMaleParticipantsLimit(), activityListVo.getFemaleParticipantsLimit(), activityListVo.getMaleRegisteredCount(), activityListVo.getFemaleRegisteredCount(), gender)).booleanValue()) continue;
            activityListVo.setStatus(3);
        }
    }

    private Boolean isFull(Integer maleParticipantsLimit, Integer femaleParticipantsLimit, Integer maleRegisteredCount, Integer femaleRegisteredCount, Integer gender) {
        if (Objects.isNull(gender)) {
            return maleParticipantsLimit + femaleParticipantsLimit <= maleRegisteredCount + femaleRegisteredCount;
        }
        return gender == 1 ? maleParticipantsLimit <= maleRegisteredCount : femaleParticipantsLimit <= femaleRegisteredCount;
    }

    private void rebuildActivityListVo(List<ActivityListVo> records) {
        List<Long> activityIds = records.stream().filter(Objects::nonNull).map(ActivityListVo::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(activityIds)) {
            return;
        }
        Map<Integer, Region> codeMap = this.getCodeMap(records);
        Map<Long, List<ActivityUserVo>> regiactUserMap = this.activityRegistrationService.getRegiactUserMap(activityIds);
        records.forEach(activityListVo -> {
            activityListVo.setActivityUserList((List)regiactUserMap.get(activityListVo.getId()));
            this.fillCodeName((ActivityListVo)activityListVo, codeMap);
        });
    }

    private void fillCodeName(ActivityListVo activityListVo, Map<Integer, Region> codeMap) {
        Integer code = Integer.parseInt(activityListVo.getCityCode());
        Region region = codeMap.get(code);
        if (region != null) {
            activityListVo.setCityName(region.getName());
        }
    }

    private static void fillCodeNameAndRegisteredCount(ActivityListVo activityListVo, Map<Integer, Region> codeMap, Map<Long, ActivityRegistrationData> registrationDataMap) {
        ActivityRegistrationData activityRegistrationData;
        Integer code = Integer.parseInt(activityListVo.getCityCode());
        Region region = codeMap.get(code);
        if (region != null) {
            activityListVo.setCityName(region.getName());
        }
        if ((activityRegistrationData = registrationDataMap.get(activityListVo.getId())) != null) {
            activityListVo.setRegisteredCount(activityRegistrationData.getRegisteredCount());
            activityListVo.setMaleRegisteredCount(activityRegistrationData.getMaleRegisteredCount());
            activityListVo.setFemaleRegisteredCount(activityRegistrationData.getFemaleRegisteredCount());
        }
    }

    private Map<Integer, Region> getCodeMap(List<ActivityListVo> records) {
        Set codeSet = records.stream().filter(Objects::nonNull).map(ActivityListVo::getCityCode).filter(Objects::nonNull).map(Integer::parseInt).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(codeSet)) {
            return Collections.emptyMap();
        }
        return Optional.ofNullable(this.regionService.listByIds(Lists.newArrayList(codeSet))).filter(CollectionUtils::isNotEmpty).map(list -> list.stream().collect(Collectors.toMap(Region::getCode, Function.identity(), (a, b) -> a))).orElse(Collections.emptyMap());
    }

    @Override
    public List<ActivityListVo> endList(Long userId, ActivityListQueryDto dto) {
        List visibleActivityIds = Objects.isNull(userId) ? Collections.emptyList() : this.getVisibleActivityIds(userId);
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime threeMonthsAgo = now.minusMonths(3L);
        List activityList = ((ActivityMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().le(Activity::getActivityEndTime, (Object)now)).ge(Activity::getCreateTime, (Object)threeMonthsAgo)).eq(Activity::getActivityStatus, (Object)1)).eq(StringUtils.isNotBlank((CharSequence)dto.getCityCode()), Activity::getCityCode, (Object)dto.getCityCode())).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(Activity::getOvertStatus, (Object)1)).or(inner -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)inner.eq(Activity::getOvertStatus, (Object)0)).in(CollectionUtils.isNotEmpty((Collection)visibleActivityIds), Activity::getId, (Collection)visibleActivityIds);
            });
        })).orderByDesc(Activity::getId));
        return this.fillList(ActivityMapping.INSTANCE.toVoList(activityList));
    }

    private List<ActivityListVo> fillList(List<ActivityListVo> activityListVos) {
        List activityIds = activityListVos.stream().filter(Objects::nonNull).map(ActivityListVo::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(activityIds)) {
            return activityListVos;
        }
        Map<Integer, Region> codeMap = this.getCodeMap(activityListVos);
        activityListVos.forEach(vo -> this.fillCodeName((ActivityListVo)vo, codeMap));
        return activityListVos;
    }

    private List<Long> getVisibleActivityIds(Long userId) {
        List<Long> organizerIds;
        User user = (User)this.userService.getById(userId);
        List<Long> visibleActivityIds = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)user.getUnionid())) {
            visibleActivityIds = ((ActivityMapper)this.baseMapper).selectVisibleActivityId(user.getUnionid());
        }
        if (StringUtils.isNotBlank((CharSequence)user.getMobile()) && CollectionUtils.isNotEmpty(organizerIds = this.activityOrganizerService.list((Wrapper)new LambdaQueryWrapper().eq(ActivityOrganizer::getMobile, (Object)user.getMobile())).stream().filter(Objects::nonNull).map(ActivityOrganizer::getId).collect(Collectors.toList()))) {
            visibleActivityIds.addAll(((ActivityMapper)this.baseMapper).selectActivityIdByOrganizerIds(organizerIds));
        }
        return visibleActivityIds;
    }

    @Override
    public ActivityDetailVo detail(UserBasicInfo userBasicInfo, Long id) {
        ActivityRegistration activityRegistration;
        LocalDateTime now;
        Map<Long, List<ActivityUserVo>> regiactUserMap;
        Activity activity = (Activity)this.getById(id);
        if (Objects.isNull(activity)) {
            return null;
        }
        ActivityDetailVo detailVo = ActivityMapping.INSTANCE.toDetailVo(activity);
        ActivityType activityType = (ActivityType)this.activityTypeService.getById(activity.getActivityTypeId());
        if (Objects.nonNull(activityType)) {
            detailVo.setActivityBizType(activityType.getBizType());
        }
        Optional.ofNullable(detailVo.getCityCode()).map(Integer::parseInt).map(arg_0 -> ((IRegionService)this.regionService).getById(arg_0)).map(Region::getName).ifPresent(detailVo::setCityName);
        Optional.ofNullable(activity.getOrganizerId()).map(arg_0 -> ((IActivityOrganizerService)this.activityOrganizerService).getById(arg_0)).map(ActivityOrganizer::getName).ifPresent(detailVo::setOrganizerName);
        GuestRecommendVo guestRecommend = detailVo.getGuestRecommend();
        Integer gender = null;
        Long userId = null;
        if (Objects.nonNull(userBasicInfo)) {
            gender = userBasicInfo.getGender();
            userId = userBasicInfo.getUserId();
        }
        if (Objects.nonNull(guestRecommend) && Objects.nonNull(gender)) {
            if (gender == 1) {
                this.buildGuestUser(guestRecommend.getFemaleGuestList());
            } else if (gender == 0) {
                this.buildGuestUser(guestRecommend.getMaleGuestList());
            }
        }
        if (MapUtils.isNotEmpty(regiactUserMap = this.activityRegistrationService.getRegiactUserMap(Lists.newArrayList((Object[])new Long[]{id})))) {
            detailVo.setActivityUserList(regiactUserMap.get(id));
        }
        if ((now = LocalDateTime.now()).isBefore(activity.getActivityStartTime())) {
            detailVo.setStatus(0);
        }
        if (now.isAfter(activity.getActivityEndTime())) {
            detailVo.setStatus(2);
        }
        if (!now.isBefore(activity.getActivityStartTime()) && !now.isAfter(activity.getActivityEndTime())) {
            detailVo.setStatus(1);
        }
        if (!activity.getRegisterStartTime().isAfter(LocalDateTime.now()) && !activity.getRegisterEndTime().isBefore(LocalDateTime.now())) {
            detailVo.setStatus(5);
        }
        BigDecimal activityPrice = this.activityRegistrationService.calculateActivityPrice(activity, userId);
        BigDecimal activityShowPrice = this.calculateActivityShowPrice(activity);
        detailVo.setActivityPrice(activityPrice);
        detailVo.setActivityShowPrice(activityShowPrice);
        if (Objects.nonNull(userId) && Objects.nonNull(activityRegistration = (ActivityRegistration)this.activityRegistrationService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityRegistration::getActivityId, (Object)id)).eq(ActivityRegistration::getUserId, (Object)userBasicInfo.getUserId())).eq(ActivityRegistration::getStatus, (Object)2)))) {
            detailVo.setRegisterStatus(2);
            return detailVo;
        }
        if (activity.getActivityStartTime().isAfter(LocalDateTime.now())) {
            Boolean full;
            if (activity.getRegisterEndTime().isBefore(LocalDateTime.now()) && activity.getActivityStartTime().isAfter(LocalDateTime.now())) {
                detailVo.setStatus(4);
            }
            if ((full = this.isFull(activity.getMaleParticipantsLimit(), activity.getFemaleParticipantsLimit(), detailVo.getMaleRegisteredCount(), detailVo.getFemaleRegisteredCount(), gender)).booleanValue()) {
                detailVo.setStatus(3);
            }
        }
        return detailVo;
    }

    private BigDecimal calculateActivityShowPrice(Activity activity) {
        if (Objects.isNull(activity.getRegisterPrice()) || activity.getRegisterPrice().compareTo(BigDecimal.ZERO) <= 0) {
            return BigDecimal.ZERO;
        }
        if (Objects.nonNull(activity.getDiscountPrice()) && Objects.nonNull(activity.getDiscountLimitType()) && activity.isDiscountApplied()) {
            return activity.getDiscountPrice();
        }
        return activity.getRegisterPrice();
    }

    @Override
    public List<ActivityListVo> myList(Long userId, ActivityListQueryDto dto) {
        List<ActivityListDao> list = ((ActivityMapper)this.baseMapper).myList(userId, dto, LocalDateTime.now());
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<ActivityListVo>();
        }
        List<ActivityListVo> activityListVos = ActivityMapping.INSTANCE.daoToVoList(list);
        if (CollectionUtils.isEmpty(activityListVos)) {
            return new ArrayList<ActivityListVo>();
        }
        this.rebuildActivityListVo(activityListVos);
        return activityListVos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void releaseStock(String orderNum) {
        RLock lock = this.redissonClient.getLock(RedisKeys.activityOrderTimeoutLock((String)orderNum).generateKey());
        boolean b = lock.tryLock();
        if (!b) {
            return;
        }
        try {
            Integer gender;
            ActivityRegistration activityRegistration = this.activityRegistrationService.getOneByOrderNo(orderNum);
            if (Objects.isNull(activityRegistration)) {
                return;
            }
            UserOrder userOrder = this.userOrderService.query(orderNum);
            if (userOrder.getStatus() >= 2) {
                return;
            }
            Long activityId = activityRegistration.getActivityId();
            if (Objects.equals(1, activityRegistration.getDiscountApplied())) {
                ((ActivityMapper)this.baseMapper).releaseDiscountRegisterCount(activityId);
                log.info("\u91ca\u653e\u65e9\u9e1f\u7968\u540d\u989d,activityId:{},userId:{}", (Object)activityId, (Object)activityRegistration.getUserId());
            }
            if (1 == (gender = activityRegistration.getGender())) {
                ((ActivityMapper)this.baseMapper).releaseMaleRegisterCount(activityId);
                log.info("\u91ca\u653e\u7537\u7968\u540d\u989d,activityId:{},userId:{}", (Object)activityId, (Object)activityRegistration.getUserId());
            } else if (0 == gender) {
                ((ActivityMapper)this.baseMapper).releaseFemaleRegisterCount(activityId);
                log.info("\u91ca\u653e\u5973\u7968\u540d\u989d,activityId:{},userId:{}", (Object)activityId, (Object)activityRegistration.getUserId());
            }
            activityRegistration.setStatus(1);
            activityRegistration.setModifyTime(LocalDateTime.now());
            this.activityRegistrationService.updateById(activityRegistration);
            this.userOrderService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(UserOrder::getStatus, (Object)3)).eq(UserOrder::getOrderNum, (Object)orderNum));
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Page<ActivityListVo> listWithOutLogin(ActivityQueryDto dto) {
        dto.setCurrent(Constants.ONE);
        dto.setSize(Integer.MAX_VALUE);
        List activityTypeList = this.activityTypeService.list((Wrapper)new LambdaQueryWrapper().eq(Objects.nonNull(dto.getType()), ActivityType::getType, (Object)dto.getType()));
        if (CollectionUtils.isEmpty((Collection)activityTypeList)) {
            return new Page();
        }
        List<Integer> typeIdList = activityTypeList.stream().filter(Objects::nonNull).map(ActivityType::getId).collect(Collectors.toList());
        Page<ActivityListDao> page = ((ActivityMapper)this.baseMapper).listWithOutLogin(new Page((long)dto.getCurrent(), (long)dto.getSize()), typeIdList, dto, LocalDateTime.now());
        if (Objects.isNull(page) || CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return new Page();
        }
        Page<ActivityListVo> voPage = ActivityMapping.INSTANCE.daoToVoPage(page);
        if (CollectionUtils.isEmpty((Collection)voPage.getRecords())) {
            return new Page();
        }
        List records = voPage.getRecords();
        this.rebuildActivityListVo(records);
        this.rebuildStatus(records);
        this.reSort(records);
        return voPage;
    }

    private void rebuildStatus(List<ActivityListVo> records) {
        records.forEach(dao -> {
            if (dao.getRegisterEndTime().isBefore(LocalDateTime.now()) && dao.getActivityStartTime().isAfter(LocalDateTime.now())) {
                dao.setStatus(4);
            }
            if (!dao.getRegisterStartTime().isAfter(LocalDateTime.now()) && !dao.getRegisterEndTime().isBefore(LocalDateTime.now())) {
                dao.setStatus(5);
                Boolean full = this.isFull(dao.getMaleParticipantsLimit(), dao.getFemaleParticipantsLimit(), dao.getMaleRegisteredCount(), dao.getFemaleRegisteredCount(), null);
                if (full.booleanValue()) {
                    dao.setStatus(3);
                }
            }
        });
    }

    private void buildGuestUser(List<GuestRecommendVo.GuestUser> guestUserList) {
        guestUserList.removeIf(guestUser -> Objects.isNull(guestUser) || Objects.isNull(guestUser.getUserId()));
        List userIdList = guestUserList.stream().filter(Objects::nonNull).map(GuestRecommendVo.GuestUser::getUserId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userIdList)) {
            return;
        }
        List userList = this.userService.listByIds(userIdList);
        if (CollectionUtils.isEmpty((Collection)userList)) {
            return;
        }
        Map<Long, User> userMap = userList.stream().collect(Collectors.toMap(User::getId, user -> user));
        List userBasicInfoList = this.userBasicInfoService.list((Wrapper)new LambdaQueryWrapper().in(UserBasicInfo::getUserId, userMap.keySet()));
        if (CollectionUtils.isEmpty((Collection)userBasicInfoList)) {
            return;
        }
        Map<Long, UserBasicInfo> userBasicInfoMap = userBasicInfoList.stream().collect(Collectors.toMap(UserBasicInfo::getUserId, user -> user));
        for (GuestRecommendVo.GuestUser guestUser2 : guestUserList) {
            User user2 = userMap.get(guestUser2.getUserId());
            UserBasicInfo basicInfo = userBasicInfoMap.get(user2.getId());
            guestUser2.setUserNumber(user2.getUserNumber());
            guestUser2.setNickname(basicInfo.getNickname());
            guestUser2.setAvatar(basicInfo.getAvatar());
            if (Objects.nonNull(basicInfo.getBirthday())) {
                guestUser2.setAge(basicInfo.getBirthday().until(LocalDate.now()).getYears());
            }
            guestUser2.setJob(basicInfo.getJob());
            guestUser2.setRuleTag(basicInfo.getRuleTag());
            guestUser2.setHeight(basicInfo.getHeight());
        }
    }

    public ActivityServiceImpl(IActivityTypeService activityTypeService, IRegionService regionService, IActivityOrganizerService activityOrganizerService, IUserBasicInfoService userBasicInfoService, IUserService userService, IActivityRegistrationService activityRegistrationService, RedissonClient redissonClient, IUserOrderService userOrderService) {
        this.activityTypeService = activityTypeService;
        this.regionService = regionService;
        this.activityOrganizerService = activityOrganizerService;
        this.userBasicInfoService = userBasicInfoService;
        this.userService = userService;
        this.activityRegistrationService = activityRegistrationService;
        this.redissonClient = redissonClient;
        this.userOrderService = userOrderService;
    }
}

