/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.contant.UserConstants;
import com.bxm.lovelink.common.dal.entity.Activity;
import com.bxm.lovelink.common.dal.entity.ActivityRegistration;
import com.bxm.lovelink.common.dal.entity.ActivityUserMutualSelection;
import com.bxm.lovelink.common.dal.entity.ActivityUserSelection;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.UserComposite;
import com.bxm.lovelink.common.dal.entity.dao.activity.ActivityUserDao;
import com.bxm.lovelink.common.dal.entity.dto.activity.usermutualselection.ActivityMutualSelectionQueryDto;
import com.bxm.lovelink.common.dal.entity.vo.activity.usermutualselection.ActivityUserSelectionResultVo;
import com.bxm.lovelink.common.dal.entity.vo.activity.usermutualselection.ActivityUserSelectionStatisticsVo;
import com.bxm.lovelink.common.dal.entity.vo.user.UserBasicInfoVo;
import com.bxm.lovelink.common.dal.entity.vo.user.UserCompositeSimpleVo;
import com.bxm.lovelink.common.dal.entity.vo.user.UserCompositeVo;
import com.bxm.lovelink.common.dal.mapper.ActivityMapper;
import com.bxm.lovelink.common.dal.mapper.ActivityRegistrationMapper;
import com.bxm.lovelink.common.dal.mapper.ActivityUserMutualSelectionMapper;
import com.bxm.lovelink.common.dal.mapper.UserBasicInfoMapper;
import com.bxm.lovelink.common.dal.mapper.UserMapper;
import com.bxm.lovelink.common.dal.mapping.UserInfoMapping;
import com.bxm.lovelink.common.dal.mapping.activity.ActivityUserMutualSelectionMapping;
import com.bxm.lovelink.common.dal.service.IActivityUserMutualSelectionService;
import com.bxm.lovelink.common.dal.service.IActivityUserSelectionService;
import com.bxm.lovelink.common.dal.service.IUserBasicInfoService;
import com.bxm.lovelink.common.utils.GeoDistanceUtils;
import com.bxm.warcar.integration.pair.Pair;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityUserMutualSelectionServiceImpl
extends ServiceImpl<ActivityUserMutualSelectionMapper, ActivityUserMutualSelection>
implements IActivityUserMutualSelectionService {
    private final ActivityRegistrationMapper activityRegistrationMapper;
    private final IUserBasicInfoService userBasicInfoService;
    private final IActivityUserSelectionService activityUserSelectionService;
    private final ActivityMapper activityMapper;
    private final Pair pair;
    private final UserBasicInfoMapper userBasicInfoMapper;
    private final UserMapper userMapper;

    @Override
    public List<UserCompositeSimpleVo> userList(ActivityMutualSelectionQueryDto dto, UserBasicInfo userBasicInfo) {
        if (Objects.isNull(dto) || Objects.isNull(userBasicInfo)) {
            return null;
        }
        List<UserComposite> list = this.userBasicInfoMapper.selectActivityUserList(dto, userBasicInfo.getReverseGender(), userBasicInfo.getUserId());
        List<UserCompositeVo> userCompositeVos = UserInfoMapping.INSTANCE.doToVo(list);
        userCompositeVos.forEach(vo -> {
            if (Objects.nonNull(vo)) {
                UserBasicInfoVo basicInfo = vo.getUserBasicInfo();
                Double distance = GeoDistanceUtils.calculateDistance(userBasicInfo.getLatitude(), userBasicInfo.getLongitude(), basicInfo.getLatitude(), basicInfo.getLongitude());
                basicInfo.setDistance(distance);
                basicInfo.setSchoolName(Objects.equals(basicInfo.getSchoolHide(), 0) ? null : basicInfo.getSchoolName());
            }
        });
        return UserInfoMapping.INSTANCE.toList(userCompositeVos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<ActivityUserSelectionResultVo> selectResult(Long activityId, UserBasicInfo userBasicInfo, User currentUser) {
        Activity activity = (Activity)this.activityMapper.selectById(activityId);
        if (Objects.isNull(activity)) {
            throw new IllegalStateException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        if (!activity.getActivityEndTime().isBefore(LocalDateTime.now())) {
            throw new IllegalStateException("\u6d3b\u52a8\u672a\u7ed3\u675f\uff0c\u65e0\u6cd5\u67e5\u770b\u4e92\u9009\u7ed3\u679c");
        }
        Long currentUserId = userBasicInfo.getUserId();
        boolean isMale = userBasicInfo.getGender().equals(1);
        List userSelections = this.activityUserSelectionService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityUserSelection::getActivityId, (Object)activityId)).eq(ActivityUserSelection::getUserId, (Object)currentUserId));
        if (CollectionUtils.isEmpty((Collection)userSelections)) {
            return Collections.emptyList();
        }
        List mutualSelections = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityUserMutualSelection::getActivityId, (Object)activityId)).eq((Object)(isMale ? ActivityUserMutualSelection::getMaleUserId : ActivityUserMutualSelection::getFemaleUserId), (Object)currentUserId));
        Map mutualMap = mutualSelections.stream().collect(Collectors.toMap(sel -> sel.getMaleUserId() + "_" + sel.getFemaleUserId(), Function.identity(), (a, b) -> a));
        List<Long> targetUserIds = userSelections.stream().filter(Objects::nonNull).map(ActivityUserSelection::getTargetUserId).collect(Collectors.toList());
        Map targetUserInfoMap = this.userBasicInfoService.listIncludeDeleted(targetUserIds).stream().collect(Collectors.toMap(UserBasicInfo::getUserId, Function.identity()));
        Map userMap = this.userMapper.selectBatchIds(targetUserIds).stream().collect(Collectors.toMap(User::getId, Function.identity()));
        List<ActivityUserSelectionResultVo> userSelectionResultVos = ActivityUserMutualSelectionMapping.INSTANCE.toVoList(userSelections);
        for (ActivityUserSelectionResultVo userSelection : userSelectionResultVos) {
            boolean mutualSelected;
            User user;
            userSelection.setNickname(userBasicInfo.getNickname());
            userSelection.setAvatar(userBasicInfo.getAvatar());
            userSelection.setUserNumber(currentUser.getUserNumber());
            Long targetUserId = userSelection.getTargetUserId();
            UserBasicInfo targetInfo = (UserBasicInfo)targetUserInfoMap.get(targetUserId);
            if (targetInfo == null || (user = (User)userMap.get(targetUserId)) == null) continue;
            userSelection.setTargetUserNumber(user.getUserNumber());
            userSelection.setTargetUserId(targetUserId);
            userSelection.setTargetUserNickname(targetInfo.getNickname());
            userSelection.setTargetUserAvatar(targetInfo.getAvatar());
            Long maleId = isMale ? currentUserId : targetUserId;
            Long femaleId = isMale ? targetUserId : currentUserId;
            String key = maleId + "_" + femaleId;
            if (mutualMap.containsKey(key)) {
                userSelection.setSelectionResult(1);
                continue;
            }
            boolean bl = mutualSelected = this.activityUserSelectionService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityUserSelection::getActivityId, (Object)activityId)).eq(ActivityUserSelection::getUserId, (Object)targetUserId)).eq(ActivityUserSelection::getTargetUserId, (Object)currentUserId)) > 0;
            if (mutualSelected) {
                userSelection.setSelectionResult(1);
                ActivityUserMutualSelection mutual = new ActivityUserMutualSelection();
                mutual.setActivityId(activityId);
                mutual.setMaleUserId(maleId);
                mutual.setFemaleUserId(femaleId);
                this.save(mutual);
                continue;
            }
            userSelection.setSelectionResult(0);
        }
        return userSelectionResultVos;
    }

    @Override
    public Boolean canFreeRegister(Long activityId, UserBasicInfo userBasicInfo) {
        Long userId = userBasicInfo.getUserId();
        Activity activity = (Activity)this.activityMapper.selectById(activityId);
        if (activity == null) {
            return false;
        }
        if (!this.activityTypeFree(activity).booleanValue()) {
            return false;
        }
        if (this.hasReceivedFree(userId, activityId, activity.getActivityTypeId())) {
            return false;
        }
        if (this.hasMutualSelection(userId, activityId, userBasicInfo.getGender())) {
            return false;
        }
        ActivityRegistration activityRegistration = this.getSuccessRegistration(userId, activityId);
        return Objects.nonNull(activityRegistration) && StringUtils.isNotBlank((CharSequence)activityRegistration.getOrderNo());
    }

    private Boolean activityTypeFree(Activity activity) {
        Set activityTypeIdSet = this.pair.get("free_registration_activity_type_id").ofHashSet();
        if (CollectionUtils.isEmpty((Collection)activityTypeIdSet)) {
            return false;
        }
        return activityTypeIdSet.contains(String.valueOf(activity.getActivityTypeId()));
    }

    @Override
    public void receiveFreeRegister(Long activityId, UserBasicInfo userBasicInfo) {
        Long userId = userBasicInfo.getUserId();
        Activity activity = (Activity)this.activityMapper.selectById(activityId);
        if (activity == null) {
            throw new IllegalStateException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        if (!this.activityTypeFree(activity).booleanValue()) {
            throw new IllegalStateException("\u5f53\u524d\u6d3b\u52a8\u7c7b\u578b\u4e0d\u652f\u6301\u9886\u53d6\u514d\u8d39\u62a5\u540d\u673a\u4f1a");
        }
        if (this.hasReceivedFree(userId, activityId, activity.getActivityTypeId())) {
            throw new IllegalStateException("\u5df2\u7ecf\u9886\u53d6\u8fc7\u514d\u8d39\u673a\u4f1a\u4e86");
        }
        if (!activity.getActivityEndTime().isBefore(LocalDateTime.now())) {
            throw new IllegalStateException("\u6d3b\u52a8\u672a\u7ed3\u675f\uff0c\u65e0\u6cd5\u9886\u53d6");
        }
        if (this.hasMutualSelection(userId, activityId, userBasicInfo.getGender())) {
            throw new IllegalStateException("\u5b58\u5728\u4e92\u9009\u6210\u529f\u7ed3\u679c\u65e0\u6cd5\u9886\u53d6");
        }
        ActivityRegistration activityRegistration = this.getSuccessRegistration(userId, activityId);
        if (Objects.isNull(activityRegistration) || StringUtils.isBlank((CharSequence)activityRegistration.getOrderNo())) {
            throw new IllegalStateException("\u975e\u4ed8\u8d39\u62a5\u540d\u65e0\u6cd5\u9886\u53d6");
        }
        activityRegistration.setFreeActivityTypeId(activity.getActivityTypeId());
        this.activityRegistrationMapper.updateById(activityRegistration);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generateMutualSelectResult(Long activityId) {
        List userSelections = this.activityUserSelectionService.list((Wrapper)new LambdaQueryWrapper().eq(ActivityUserSelection::getActivityId, (Object)activityId));
        if (CollectionUtils.isEmpty((Collection)userSelections)) {
            return;
        }
        Set existingMutualKeys = this.list((Wrapper)new LambdaQueryWrapper().eq(ActivityUserMutualSelection::getActivityId, (Object)activityId)).stream().map(mutual -> mutual.getMaleUserId() + "_" + mutual.getFemaleUserId()).collect(Collectors.toSet());
        Set allUserIds = userSelections.stream().flatMap(s -> Stream.of(s.getUserId(), s.getTargetUserId())).collect(Collectors.toSet());
        Map userInfoMap = this.userBasicInfoService.listIncludeDeleted(new ArrayList<Long>(allUserIds)).stream().collect(Collectors.toMap(UserBasicInfo::getUserId, Function.identity()));
        HashMap selectionMap = new HashMap();
        ArrayList<ActivityUserMutualSelection> mutualInsertList = new ArrayList<ActivityUserMutualSelection>();
        for (ActivityUserSelection userSelection : userSelections) {
            Long femaleId;
            selectionMap.computeIfAbsent(userSelection.getUserId(), k -> new HashSet()).add(userSelection.getTargetUserId());
            Long userId = userSelection.getUserId();
            Long targetUserId = userSelection.getTargetUserId();
            UserBasicInfo userInfo = (UserBasicInfo)userInfoMap.get(userId);
            if (Objects.isNull(userInfo)) continue;
            boolean isMale = userInfo.getGender().equals(1);
            Long maleId = isMale ? userId : targetUserId;
            Long l = femaleId = isMale ? targetUserId : userId;
            String mutualKey = maleId + "_" + femaleId;
            if (existingMutualKeys.contains(mutualKey) || !selectionMap.getOrDefault(targetUserId, Collections.emptySet()).contains(userId)) continue;
            ActivityUserMutualSelection mutual2 = new ActivityUserMutualSelection();
            mutual2.setActivityId(activityId);
            mutual2.setMaleUserId(maleId);
            mutual2.setFemaleUserId(femaleId);
            mutualInsertList.add(mutual2);
            existingMutualKeys.add(mutualKey);
        }
        if (CollectionUtils.isNotEmpty(mutualInsertList)) {
            this.saveBatch(mutualInsertList);
        }
    }

    @Override
    public boolean exists(Long maleUserId, Long femaleUserId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityUserMutualSelection::getMaleUserId, (Object)maleUserId)).eq(ActivityUserMutualSelection::getFemaleUserId, (Object)femaleUserId);
        return this.count((Wrapper)wrapper) > 0;
    }

    @Override
    public void deleteUserMutualSelection(Long userId, Integer gender) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (1 == gender) {
            queryWrapper.eq(ActivityUserMutualSelection::getMaleUserId, (Object)userId);
        } else if (0 == gender) {
            queryWrapper.eq(ActivityUserMutualSelection::getFemaleUserId, (Object)userId);
        }
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public ActivityUserSelectionStatisticsVo statistics(ActivityMutualSelectionQueryDto dto, UserBasicInfo userBasicInfo) {
        ActivityUserSelectionStatisticsVo statisticsVo = new ActivityUserSelectionStatisticsVo();
        List<ActivityUserDao> list = this.activityRegistrationMapper.selectActivityUserList(new ActivityMutualSelectionQueryDto().setActivityId(dto.getActivityId()), userBasicInfo.getReverseGender(), userBasicInfo.getUserId());
        List<ActivityUserDao> heartMeList = this.activityRegistrationMapper.selectActivityUserList(new ActivityMutualSelectionQueryDto().setActivityId(dto.getActivityId()).setTabType(ActivityMutualSelectionQueryDto.TabType.HEART_ME), userBasicInfo.getReverseGender(), userBasicInfo.getUserId());
        List<ActivityUserDao> myHeartList = this.activityRegistrationMapper.selectActivityUserList(new ActivityMutualSelectionQueryDto().setActivityId(dto.getActivityId()).setTabType(ActivityMutualSelectionQueryDto.TabType.MY_HEART), userBasicInfo.getReverseGender(), userBasicInfo.getUserId());
        statisticsVo.setTotalCount(Long.valueOf(list.size()));
        statisticsVo.setHeartMeCount(Long.valueOf(heartMeList.size()));
        statisticsVo.setMyHeartCount(Long.valueOf(myHeartList.size()));
        if (Objects.isNull(dto.getTabType())) {
            return this.buildStatisticsVo(statisticsVo, list);
        }
        if (dto.getTabType().equals(ActivityMutualSelectionQueryDto.TabType.HEART_ME)) {
            return this.buildStatisticsVo(statisticsVo, heartMeList);
        }
        if (dto.getTabType().equals(ActivityMutualSelectionQueryDto.TabType.MY_HEART)) {
            return this.buildStatisticsVo(statisticsVo, myHeartList);
        }
        return statisticsVo;
    }

    private ActivityUserSelectionStatisticsVo buildStatisticsVo(ActivityUserSelectionStatisticsVo statisticsVo, List<ActivityUserDao> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            long realNameCount = list.stream().filter(Objects::nonNull).filter(u -> u.getCertStatus().contains(UserConstants.CertTypeEnum.REAL_PEOPLE.getCode())).count();
            statisticsVo.setRealNameCount(realNameCount);
            long marriageCount = list.stream().filter(Objects::nonNull).filter(u -> u.getCertStatus().contains(UserConstants.CertTypeEnum.MARRIED.getCode())).count();
            statisticsVo.setMarriageCount(marriageCount);
            long educationCount = list.stream().filter(Objects::nonNull).filter(u -> u.getCertStatus().contains(UserConstants.CertTypeEnum.EDU.getCode())).count();
            statisticsVo.setEducationCount(educationCount);
            long carCount = list.stream().filter(Objects::nonNull).filter(u -> u.getCertStatus().contains(UserConstants.CertTypeEnum.CAR.getCode())).count();
            statisticsVo.setCarCount(carCount);
        }
        return statisticsVo;
    }

    private boolean hasMutualSelection(Long userId, Long activityId, Integer gender) {
        boolean isMale = gender.equals(1);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityUserMutualSelection::getActivityId, (Object)activityId)).eq((Object)(isMale ? ActivityUserMutualSelection::getMaleUserId : ActivityUserMutualSelection::getFemaleUserId), (Object)userId);
        return this.count((Wrapper)wrapper) > 0;
    }

    private boolean hasSelection(Long userId, Long activityId) {
        return this.activityUserSelectionService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityUserSelection::getActivityId, (Object)activityId)).eq(ActivityUserSelection::getUserId, (Object)userId)) > 0;
    }

    private boolean hasReceivedFree(Long userId, Long activityId, Long activityTypeId) {
        return this.activityRegistrationMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityRegistration::getUserId, (Object)userId)).eq(ActivityRegistration::getActivityId, (Object)activityId)).eq(ActivityRegistration::getFreeActivityTypeId, (Object)activityTypeId)) > 0;
    }

    private ActivityRegistration getSuccessRegistration(Long userId, Long activityId) {
        return (ActivityRegistration)this.activityRegistrationMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityRegistration::getUserId, (Object)userId)).eq(ActivityRegistration::getActivityId, (Object)activityId)).eq(ActivityRegistration::getStatus, (Object)2));
    }

    public ActivityUserMutualSelectionServiceImpl(ActivityRegistrationMapper activityRegistrationMapper, IUserBasicInfoService userBasicInfoService, IActivityUserSelectionService activityUserSelectionService, ActivityMapper activityMapper, Pair pair, UserBasicInfoMapper userBasicInfoMapper, UserMapper userMapper) {
        this.activityRegistrationMapper = activityRegistrationMapper;
        this.userBasicInfoService = userBasicInfoService;
        this.activityUserSelectionService = activityUserSelectionService;
        this.activityMapper = activityMapper;
        this.pair = pair;
        this.userBasicInfoMapper = userBasicInfoMapper;
        this.userMapper = userMapper;
    }
}

