/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.dal.entity.Activity;
import com.bxm.lovelink.common.dal.entity.ActivityRegistration;
import com.bxm.lovelink.common.dal.entity.ActivityUserSelection;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.dto.activity.userselection.ActivityUserSelectionDto;
import com.bxm.lovelink.common.dal.entity.vo.activity.userselection.ActivityUserSelectionVo;
import com.bxm.lovelink.common.dal.mapper.ActivityMapper;
import com.bxm.lovelink.common.dal.mapper.ActivityRegistrationMapper;
import com.bxm.lovelink.common.dal.mapper.ActivityUserSelectionMapper;
import com.bxm.lovelink.common.dal.service.IActivityTypeService;
import com.bxm.lovelink.common.dal.service.IActivityUserSelectionService;
import com.bxm.lovelink.common.dal.service.IUserBasicInfoService;
import com.bxm.lovelink.constant.RedisKeys;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityUserSelectionServiceImpl
extends ServiceImpl<ActivityUserSelectionMapper, ActivityUserSelection>
implements IActivityUserSelectionService {
    private final ActivityMapper activityMapper;
    private final ActivityRegistrationMapper activityRegistrationMapper;
    private final IUserBasicInfoService userBasicInfoService;
    private final IActivityTypeService activityTypeService;
    private final RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(ActivityUserSelectionDto dto, UserBasicInfo userBasicInfo) {
        if (Objects.isNull(dto) || Objects.isNull(userBasicInfo)) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Activity activity = (Activity)this.activityMapper.selectById(dto.getActivityId());
        if (Objects.isNull(activity)) {
            throw new IllegalStateException("\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        Boolean supportMutualSelection = this.activityTypeService.supportMutualSelection(activity.getActivityTypeId());
        if (!supportMutualSelection.booleanValue()) {
            throw new IllegalStateException("\u6d3b\u52a8\u4e0d\u652f\u6301\u4e92\u9009");
        }
        if (activity.getActivityEndTime().isBefore(LocalDateTime.now())) {
            throw new IllegalStateException("\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
        if (activity.getActivityStartTime().isAfter(LocalDateTime.now())) {
            throw new IllegalStateException("\u6d3b\u52a8\u672a\u5f00\u59cb");
        }
        ActivityRegistration activityRegistration = (ActivityRegistration)this.activityRegistrationMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityRegistration::getActivityId, (Object)dto.getActivityId())).eq(ActivityRegistration::getUserId, (Object)userBasicInfo.getUserId())).eq(ActivityRegistration::getStatus, (Object)2));
        if (activityRegistration == null) {
            throw new IllegalStateException("\u60a8\u672a\u62a5\u540d");
        }
        RLock lock = this.redissonClient.getLock(RedisKeys.activityUserSelectionLock((Long)dto.getActivityId(), (Long)userBasicInfo.getUserId()).generateKey());
        boolean b = lock.tryLock();
        if (!b) {
            throw new IllegalStateException("\u6b63\u5728\u9009\u62e9\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        try {
            Long currentUserId = userBasicInfo.getUserId();
            Integer gender = userBasicInfo.getGender();
            Long selectedUserId = dto.getSelectedUserId();
            UserBasicInfo selectedUser = this.userBasicInfoService.getOneByUserId(selectedUserId);
            if (Objects.isNull(selectedUser)) {
                throw new IllegalStateException("\u6240\u9009\u62e9\u7684\u7528\u6237\u5df2\u6ce8\u9500");
            }
            if (Objects.equals(selectedUser.getGender(), gender)) {
                throw new IllegalStateException("\u4e0d\u80fd\u9009\u62e9\u540c\u6027\u522b\u7528\u6237");
            }
            if (this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityUserSelection::getActivityId, (Object)dto.getActivityId())).eq(ActivityUserSelection::getUserId, (Object)currentUserId)).eq(ActivityUserSelection::getTargetUserId, (Object)selectedUserId)) > 0) {
                throw new IllegalStateException("\u5df2\u9009\u62e9\u8fc7\u8be5\u7528\u6237");
            }
            ActivityUserSelection selection = new ActivityUserSelection();
            selection.setActivityId(dto.getActivityId());
            selection.setUserId(currentUserId);
            selection.setTargetUserId(selectedUserId);
            this.save(selection);
            activityRegistration.setSignInStatus(1);
            activityRegistration.setSignInTime(LocalDateTime.now());
            this.activityRegistrationMapper.updateById(activityRegistration);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void deleteByActivityIdAndSelectedUserId(Long userId, ActivityUserSelectionDto dto) {
        ActivityUserSelection userSelection = (ActivityUserSelection)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityUserSelection::getActivityId, (Object)dto.getActivityId())).eq(ActivityUserSelection::getUserId, (Object)userId)).eq(ActivityUserSelection::getTargetUserId, (Object)dto.getSelectedUserId()));
        if (Objects.isNull(userSelection)) {
            return;
        }
        this.removeById(userSelection);
    }

    @Override
    public List<ActivityUserSelectionVo> list(Long userId, Long activityId) {
        List userSelections = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ActivityUserSelection::getActivityId, (Object)activityId)).eq(ActivityUserSelection::getUserId, (Object)userId));
        if (CollectionUtils.isEmpty((Collection)userSelections)) {
            return Collections.emptyList();
        }
        List<Long> userIds = userSelections.stream().filter(Objects::nonNull).map(ActivityUserSelection::getTargetUserId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyList();
        }
        List<UserBasicInfo> userBasicInfos = this.userBasicInfoService.listIncludeDeleted(userIds);
        if (CollectionUtils.isEmpty(userBasicInfos)) {
            return Collections.emptyList();
        }
        Map<Long, UserBasicInfo> userBasicInfoMap = userBasicInfos.stream().filter(Objects::nonNull).collect(Collectors.toMap(UserBasicInfo::getUserId, user -> user));
        return userSelections.stream().map(userSelection -> {
            ActivityUserSelectionVo vo = new ActivityUserSelectionVo();
            vo.setUserId(userSelection.getTargetUserId());
            vo.setAvatar(((UserBasicInfo)userBasicInfoMap.get(userSelection.getTargetUserId())).getAvatar());
            return vo;
        }).collect(Collectors.toList());
    }

    public ActivityUserSelectionServiceImpl(ActivityMapper activityMapper, ActivityRegistrationMapper activityRegistrationMapper, IUserBasicInfoService userBasicInfoService, IActivityTypeService activityTypeService, RedissonClient redissonClient) {
        this.activityMapper = activityMapper;
        this.activityRegistrationMapper = activityRegistrationMapper;
        this.userBasicInfoService = userBasicInfoService;
        this.activityTypeService = activityTypeService;
        this.redissonClient = redissonClient;
    }
}

