/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.bxm.lovelink.common.dal.entity.vo.file.FileUploadResultVo;
import com.bxm.lovelink.common.dal.service.FileService;
import com.bxm.warcar.file.upload.HttpFileManager;
import com.bxm.warcar.file.upload.HttpFileRequest;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileServiceImpl
implements FileService {
    private static final Logger log = LoggerFactory.getLogger(FileServiceImpl.class);
    @Autowired
    private HttpFileManager httpFileManager;

    @Override
    public FileUploadResultVo upload(MultipartFile file) {
        if (Objects.isNull(file)) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FileUploadResultVo fileUploadResultVo = new FileUploadResultVo();
        try {
            byte[] bytes = file.getBytes();
            String md5 = DigestUtils.md5DigestAsHex((byte[])bytes);
            fileUploadResultVo.setMd5(md5);
            String url = this.httpFileManager.upload(new HttpFileRequest(file));
            fileUploadResultVo.setUrl(url);
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new IllegalArgumentException("\u4e0a\u4f20\u5931\u8d25");
        }
        return fileUploadResultVo;
    }
}

