/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.bxm.lovelink.common.dal.entity.FlowControl;
import com.bxm.lovelink.common.dal.service.IFlowControlService;
import com.bxm.lovelink.common.exception.BusinessException;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service
public class FlowControlServiceImpl
implements IFlowControlService,
InitializingBean {
    private final JedisPool jedisPool;
    private String scriptSha;

    public FlowControlServiceImpl(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public boolean permitPass(FlowControl dto) {
        if (Objects.isNull(dto) || !dto.check()) {
            throw new BusinessException("\u9650\u6d41\u53c2\u6570\u5f02\u5e38");
        }
        try (Jedis resource = this.jedisPool.getResource();){
            Long result = (Long)resource.evalsha(this.scriptSha, (List)Lists.newArrayList((Object[])new String[]{dto.getRedisKey()}), (List)Lists.newArrayList((Object[])new String[]{String.valueOf(dto.getCountExpireTime()), String.valueOf(dto.getLimitExpireTime()), String.valueOf(dto.getCountThreshold())}));
            boolean bl = Objects.equals(result, 1L);
            return bl;
        }
    }

    @Override
    public boolean permitPass(List<FlowControl> dtoList) {
        boolean result = true;
        for (FlowControl dto : dtoList) {
            result = result && this.permitPass(dto);
        }
        return result;
    }

    @Override
    public boolean permitPassTruncation(List<FlowControl> dtoList) {
        for (FlowControl dto : dtoList) {
            boolean result = this.permitPass(dto);
            if (result) continue;
            return false;
        }
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        String script = "local key = KEYS[1]\nlocal countTime = tonumber(ARGV[1])\nlocal expireTime = tonumber(ARGV[2])\nlocal threshold = tonumber(ARGV[3])+1\n\nlocal value = redis.call('INCR', key)\n\nif value == 1 then\n    redis.call('EXPIRE', key, countTime)\nend\n\nif value == threshold then\n    if expireTime >= 0 then\n        redis.call('EXPIRE', key, expireTime)\n    elseif expireTime == -1 then\n        redis.call('PERSIST', key)\n    end\nend\n\nif value < threshold then\n    return 1\nelse\n    return 0\nend";
        try (Jedis resource = this.jedisPool.getResource();){
            this.scriptSha = resource.scriptLoad(script);
        }
    }
}

