/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.contant.UserConstants;
import com.bxm.lovelink.common.dal.entity.InviteConfig;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.UserOtherInfo;
import com.bxm.lovelink.common.dal.entity.UserRelation;
import com.bxm.lovelink.common.dal.entity.UserVisitRecord;
import com.bxm.lovelink.common.dal.entity.dao.heartbeat.HeartBeatLisDao;
import com.bxm.lovelink.common.dal.entity.dto.heartbeat.HeartBeatDto;
import com.bxm.lovelink.common.dal.entity.dto.heartbeat.HeartBeatQueryDto;
import com.bxm.lovelink.common.dal.entity.dto.heartbeat.HeartBeatReadDto;
import com.bxm.lovelink.common.dal.entity.dto.heartbeat.UserClearUnReadDto;
import com.bxm.lovelink.common.dal.entity.vo.heartbeat.HeartBeatListVo;
import com.bxm.lovelink.common.dal.entity.vo.heartbeat.HeartBeatResultVo;
import com.bxm.lovelink.common.dal.entity.vo.heartbeat.HeartBeatUnreadCountVo;
import com.bxm.lovelink.common.dal.mapper.UserRelationMapper;
import com.bxm.lovelink.common.dal.mapper.UserVisitRecordMapper;
import com.bxm.lovelink.common.dal.mapping.HeartBeatMapping;
import com.bxm.lovelink.common.dal.service.HeartBeatService;
import com.bxm.lovelink.common.dal.service.IRegionService;
import com.bxm.lovelink.common.dal.service.ISwipeControlService;
import com.bxm.lovelink.common.dal.service.IUserOnlineService;
import com.bxm.lovelink.common.dal.service.IUserOtherInfoService;
import com.bxm.lovelink.common.dal.service.IUserRelationService;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.utils.JsonHelper;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class HeartBeatServiceImpl
implements HeartBeatService {
    private static final Logger log = LoggerFactory.getLogger(HeartBeatServiceImpl.class);
    private final UserRelationMapper userRelationMapper;
    private final IUserOtherInfoService userOtherInfoService;
    private final IRegionService regionService;
    private final Counter counter;
    private final Pair pair;
    private final ISwipeControlService swipeControlService;
    private final IUserOnlineService userOnlineService;
    private final UserVisitRecordMapper userVisitRecordMapper;
    private final IUserRelationService userRelationService;

    public HeartBeatServiceImpl(UserRelationMapper userRelationMapper, IUserOtherInfoService userOtherInfoService, IRegionService regionService, Counter counter, Pair pair, ISwipeControlService swipeControlService, IUserOnlineService userOnlineService, UserVisitRecordMapper userVisitRecordMapper, IUserRelationService userRelationService) {
        this.userRelationMapper = userRelationMapper;
        this.userOtherInfoService = userOtherInfoService;
        this.regionService = regionService;
        this.counter = counter;
        this.pair = pair;
        this.swipeControlService = swipeControlService;
        this.userOnlineService = userOnlineService;
        this.userVisitRecordMapper = userVisitRecordMapper;
        this.userRelationService = userRelationService;
    }

    @Override
    public IPage<HeartBeatListVo> queryMyHeartBeatList(HeartBeatQueryDto dto) {
        this.validateLocationIfRequired(dto);
        int total = this.userRelationMapper.countMyHeartBeatList(dto);
        if (total == 0) {
            return new Page((long)dto.getCurrent(), (long)dto.getSize());
        }
        int offset = (dto.getCurrent() - 1) * dto.getSize();
        List<HeartBeatLisDao> list = this.userRelationMapper.queryMyHeartBeatList(dto, offset, dto.getSize());
        return this.getHeartBeatListVoPage(dto, total, list);
    }

    private void fillCityName(Page<HeartBeatListVo> page) {
        List<Integer> cityCodeList = page.getRecords().stream().map(HeartBeatListVo::getCurrentPlaceCity).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(cityCodeList)) {
            return;
        }
        Map<Integer, String> codeNameMap = this.regionService.queryByCodes(cityCodeList);
        if (MapUtils.isEmpty(codeNameMap)) {
            return;
        }
        page.getRecords().forEach(vo -> {
            Integer cityCode = vo.getCurrentPlaceCity();
            if (cityCode != null) {
                vo.setCurrentPlaceCityName((String)codeNameMap.get(cityCode));
            }
        });
    }

    @Override
    public IPage<HeartBeatListVo> queryHeartBeatMeList(HeartBeatQueryDto dto) {
        this.validateLocationIfRequired(dto);
        int total = this.userRelationMapper.countHeartBeatMeList(dto);
        if (total == 0) {
            return new Page((long)dto.getCurrent(), (long)dto.getSize());
        }
        int offset = (dto.getCurrent() - 1) * dto.getSize();
        List<HeartBeatLisDao> list = this.userRelationMapper.queryHeartBeatMeList(dto, offset, dto.getSize());
        return this.getHeartBeatListVoPage(dto, total, list);
    }

    private IPage<HeartBeatListVo> getHeartBeatListVoPage(HeartBeatQueryDto dto, int total, List<HeartBeatLisDao> list) {
        Page heartBeatLisDaoPage = new Page((long)dto.getCurrent(), (long)dto.getSize(), (long)total);
        heartBeatLisDaoPage.setRecords(list);
        Page<HeartBeatListVo> page = HeartBeatMapping.INSTANCE.toPage((IPage<HeartBeatLisDao>)heartBeatLisDaoPage);
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return page;
        }
        this.fillCityName(page);
        this.fillOnlineStatus(page.getRecords());
        return page;
    }

    private void fillOnlineStatus(List<HeartBeatListVo> records) {
        List<Long> userIds = records.stream().filter(Objects::nonNull).map(HeartBeatListVo::getUserId).collect(Collectors.toList());
        Map<Long, LocalDateTime> onlineMap = this.userOnlineService.getBatchLastOnlineTime(userIds);
        if (MapUtils.isEmpty(onlineMap)) {
            return;
        }
        for (HeartBeatListVo record : records) {
            LocalDateTime lastOnlineTime = onlineMap.get(record.getUserId());
            if (!Objects.nonNull(lastOnlineTime)) continue;
            record.setOnlineStatus(HeartBeatServiceImpl.getOnlineStatus(lastOnlineTime));
        }
    }

    private static String getOnlineStatus(LocalDateTime lastOnlineTime) {
        Duration duration = Duration.between(lastOnlineTime, LocalDateTime.now());
        long minutes = duration.toMinutes();
        long hours = duration.toHours();
        long days = duration.toDays();
        if (minutes <= 20L) {
            return "\u5f53\u524d\u5728\u7ebf";
        }
        if (hours < 1L) {
            return minutes + "\u5206\u949f\u524d\u5728\u7ebf";
        }
        if (hours < 24L) {
            return hours + "\u5c0f\u65f6\u524d\u5728\u7ebf";
        }
        return days + "\u5929\u524d\u5728\u7ebf";
    }

    private void validateLocationIfRequired(HeartBeatQueryDto dto) {
        if (StringUtils.equals((CharSequence)dto.getOrderBy(), (CharSequence)HeartBeatQueryDto.OrderByEnum.DISTANCE.getValue()) && (dto.getLat() == null || dto.getLon() == null)) {
            throw new IllegalArgumentException("\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public HeartBeatResultVo swipe(UserBasicInfo userBasicInfo, HeartBeatDto heartBeatDto) {
        boolean isRealPeople;
        HeartBeatResultVo resultVo = new HeartBeatResultVo();
        log.info("heartBeatDto userId\uff1a{}\uff0cheartBeatDto:{}", (Object)userBasicInfo.getUserId(), (Object)JsonHelper.convert((Object)heartBeatDto));
        Long userId = userBasicInfo.getUserId();
        Objects.requireNonNull(userId, "\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a");
        Long targetUserId = heartBeatDto.getTargetUserId();
        Integer relationType = heartBeatDto.getType();
        List<Integer> certStatus = userBasicInfo.getCertStatus();
        boolean bl = isRealPeople = !CollectionUtils.isEmpty(certStatus) && certStatus.contains(UserConstants.CertTypeEnum.REAL_PEOPLE.getCode());
        if (heartBeatDto.getChannel().equals(1)) {
            Integer swipeResult = this.allowSwipe(userId, isRealPeople);
            if (!isRealPeople) {
                if (swipeResult == -1) {
                    return resultVo.setReachedRealNameLimit(true).setAllowSwipe(false);
                }
                if (relationType.equals(Constants.UserRelationType.HEARTBEAT.getType())) {
                    resultVo.setReachedRealNameLimit(true);
                }
            }
        }
        int heartBeatStatus = 1;
        if (Constants.UserRelationType.HEARTBEAT.getType().equals(relationType)) {
            UserOtherInfo userOtherInfo = this.userOtherInfoService.getOneByUserId(userId);
            heartBeatStatus = Optional.ofNullable(userOtherInfo).map(UserOtherInfo::getBasicInfoGuideFinished).orElse(0);
        }
        UserRelation myRelation = (UserRelation)this.userRelationMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UserRelation::getUserId, (Object)userId)).eq(UserRelation::getTargetUserId, (Object)targetUserId)).eq(UserRelation::getDeleted, (Object)0));
        UserRelation hisRelation = (UserRelation)this.userRelationMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UserRelation::getUserId, (Object)targetUserId)).eq(UserRelation::getTargetUserId, (Object)userId)).eq(UserRelation::getDeleted, (Object)0));
        if (myRelation == null && hisRelation == null) {
            return this.handleBothNone(userId, targetUserId, relationType, resultVo, heartBeatStatus);
        }
        if (myRelation == null) {
            return this.handleMyNoneHisExist(userId, targetUserId, relationType, hisRelation, resultVo, heartBeatStatus);
        }
        if (hisRelation == null) {
            return this.handleMyExistHisNone(userId, targetUserId, relationType, myRelation, resultVo, heartBeatStatus);
        }
        return this.handleBothExist(userId, targetUserId, relationType, myRelation, hisRelation, resultVo, heartBeatStatus);
    }

    private HeartBeatResultVo handleBothExist(Long userId, Long targetUserId, Integer relationType, UserRelation myRelation, UserRelation hisRelation, HeartBeatResultVo resultVo, int heartBeatStatus) {
        if (relationType.equals(Constants.UserRelationType.HEARTBEAT.getType())) {
            if (Constants.UserRelationType.DISLIKE.getType().equals(myRelation.getType())) {
                boolean matched = Constants.UserRelationType.HEARTBEAT.getType().equals(hisRelation.getType());
                this.updateRelation(myRelation, relationType, matched, heartBeatStatus);
                this.incrBeLoved(targetUserId, heartBeatStatus);
                if (matched && 0 == hisRelation.getMatched()) {
                    this.updateMatched(hisRelation, true);
                }
                return resultVo.setMatched(matched);
            }
            if (Constants.UserRelationType.HEARTBEAT.getType().equals(myRelation.getType()) && Constants.UserRelationType.HEARTBEAT.getType().equals(hisRelation.getType())) {
                if (1 == myRelation.getMatched()) {
                    return resultVo.setBeforeMatched(true);
                }
                this.updateMatched(myRelation, true);
                this.updateMatched(hisRelation, true);
                return resultVo.setMatched(true);
            }
        }
        if (Constants.UserRelationType.HEARTBEAT.getType().equals(myRelation.getType())) {
            this.updateRelation(myRelation, relationType, false, heartBeatStatus);
            if (Constants.UserRelationType.HEARTBEAT.getType().equals(hisRelation.getType()) && 1 == hisRelation.getMatched()) {
                this.updateMatched(hisRelation, false);
            }
            this.decrBeLovedIfNeeded(myRelation, heartBeatStatus);
        }
        return resultVo;
    }

    private HeartBeatResultVo handleMyExistHisNone(Long userId, Long targetUserId, Integer relationType, UserRelation myRelation, HeartBeatResultVo resultVo, int heartBeatStatus) {
        if (relationType.equals(Constants.UserRelationType.HEARTBEAT.getType())) {
            if (!myRelation.getType().equals(relationType)) {
                this.updateRelation(myRelation, relationType, false, heartBeatStatus);
                this.incrBeLoved(targetUserId, heartBeatStatus);
            }
        } else if (relationType.equals(Constants.UserRelationType.DISLIKE.getType()) && !myRelation.getType().equals(relationType)) {
            this.updateRelation(myRelation, relationType, false, heartBeatStatus);
            this.decrBeLovedIfNeeded(myRelation, heartBeatStatus);
        }
        return resultVo;
    }

    private HeartBeatResultVo handleMyNoneHisExist(Long userId, Long targetUserId, Integer relationType, UserRelation hisRelation, HeartBeatResultVo resultVo, int heartBeatStatus) {
        if (relationType.equals(Constants.UserRelationType.HEARTBEAT.getType())) {
            boolean matched = Constants.UserRelationType.HEARTBEAT.getType().equals(hisRelation.getType());
            this.insertRelation(userId, targetUserId, relationType, matched, heartBeatStatus);
            this.incrBeLoved(targetUserId, heartBeatStatus);
            if (matched && 0 == hisRelation.getMatched()) {
                this.updateMatched(hisRelation, true);
            }
            return resultVo.setMatched(matched);
        }
        this.insertRelation(userId, targetUserId, relationType, false, heartBeatStatus);
        return resultVo;
    }

    private HeartBeatResultVo handleBothNone(Long userId, Long targetUserId, Integer relationType, HeartBeatResultVo resultVo, int heartBeatStatus) {
        if (relationType.equals(Constants.UserRelationType.HEARTBEAT.getType())) {
            this.insertRelation(userId, targetUserId, relationType, false, heartBeatStatus);
            this.incrBeLoved(targetUserId, heartBeatStatus);
        } else if (relationType.equals(Constants.UserRelationType.DISLIKE.getType())) {
            this.insertRelation(userId, targetUserId, relationType, false, heartBeatStatus);
        }
        return resultVo;
    }

    private void insertRelation(Long userId, Long targetUserId, Integer type, boolean matched, int heartBeatStatus) {
        this.userRelationMapper.insert(new UserRelation().setUserId(userId).setTargetUserId(targetUserId).setType(type).setMatched(matched ? 1 : 0).setModifyTime(LocalDateTime.now()).setHeartBeatStatus(heartBeatStatus));
    }

    private void updateRelation(UserRelation relation, Integer type, boolean matched, int heartBeatStatus) {
        relation.setType(type).setMatched(matched ? 1 : 0).setModifyTime(LocalDateTime.now()).setHeartBeatStatus(heartBeatStatus);
        this.userRelationMapper.updateById(relation);
    }

    private void updateMatched(UserRelation relation, boolean matched) {
        relation.setMatched(matched ? 1 : 0).setModifyTime(LocalDateTime.now());
        this.userRelationMapper.updateById(relation);
    }

    private void incrBeLoved(Long targetUserId, Integer heartBeatStatus) {
        if (heartBeatStatus.equals(1)) {
            this.counter.hincrementAndGet(RedisKeys.userBeLoveCount(), targetUserId.toString(), RedisKeys.expireTimeOneDay.intValue());
            this.userOtherInfoService.incrPassiveLoveCount(targetUserId, 1);
        }
    }

    private void decrBeLovedIfNeeded(UserRelation relation, Integer heartBeatStatus) {
        if (heartBeatStatus.equals(1) && relation.getType().equals(Constants.UserRelationType.HEARTBEAT.getType())) {
            this.userOtherInfoService.incrPassiveLoveCount(relation.getTargetUserId(), -1);
        }
    }

    private Integer allowSwipe(Long userId, boolean isRealPeople) {
        String date = LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE);
        KeyGenerator inviteUserRewardCountKey = RedisKeys.inviteUserRewardCount((Long)userId);
        Long inviteBrowseCount = (Long)ObjectUtils.defaultIfNull((Object)this.counter.hget(inviteUserRewardCountKey, date), (Object)0L);
        InviteConfig inviteConfig = new InviteConfig();
        String data = this.pair.get("invite_config").of();
        if (StringUtils.isNotBlank((CharSequence)data)) {
            inviteConfig = (InviteConfig)JsonHelper.convert((String)data, InviteConfig.class);
        }
        int todayLimit = isRealPeople ? inviteConfig.getBasicBrowseCount() + inviteBrowseCount.intValue() : inviteConfig.getNoCertBrowseCount() + inviteBrowseCount.intValue();
        return this.swipeControlService.doSwipe(RedisKeys.swipeCountKey((Long)userId, (String)date).generateKey(), todayLimit, Constants.SWIPE_EXPIRE_TIME_IN_SECONDS);
    }

    @Override
    public Integer unReadCount(Long userId) {
        LambdaQueryWrapper lambdaQuery = new LambdaQueryWrapper();
        lambdaQuery.eq(UserRelation::getTargetUserId, (Object)userId);
        lambdaQuery.eq(UserRelation::getDeleted, (Object)0);
        lambdaQuery.eq(UserRelation::getType, (Object)Constants.UserRelationType.HEARTBEAT.getType());
        lambdaQuery.eq(UserRelation::getReadStatus, (Object)0);
        lambdaQuery.eq(UserRelation::getHeartBeatStatus, (Object)1);
        return this.userRelationMapper.selectCount((Wrapper)lambdaQuery);
    }

    @Override
    public void read(Long userId, HeartBeatReadDto heartBeatReadDto) {
        UserRelation userRelation = (UserRelation)this.userRelationMapper.selectById(heartBeatReadDto.getId());
        if (Objects.isNull(userRelation)) {
            throw new IllegalStateException("\u5fc3\u52a8\u6d88\u606f\u4e0d\u5b58\u5728");
        }
        if (!userId.equals(userRelation.getTargetUserId())) {
            throw new IllegalStateException("\u65e0\u6743\u9650\u64cd\u4f5c");
        }
        userRelation.setReadStatus(1);
        this.userRelationMapper.updateById(userRelation);
    }

    @Override
    public HeartBeatUnreadCountVo countUnread(Long userId) {
        LambdaQueryWrapper lambdaQuery = new LambdaQueryWrapper();
        lambdaQuery.eq(UserRelation::getTargetUserId, (Object)userId);
        lambdaQuery.eq(UserRelation::getType, (Object)Constants.UserRelationType.HEARTBEAT.getType());
        lambdaQuery.eq(UserRelation::getReadStatus, (Object)0);
        lambdaQuery.eq(UserRelation::getHeartBeatStatus, (Object)1);
        Integer heartBeatMeCount = this.userRelationMapper.selectCount((Wrapper)lambdaQuery);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UserVisitRecord::getTargetUserId, (Object)userId);
        queryWrapper.eq(UserVisitRecord::getReadStatus, (Object)0);
        Integer visitorCount = this.userVisitRecordMapper.selectCount((Wrapper)queryWrapper);
        return new HeartBeatUnreadCountVo().setHeartBeatMeCount(heartBeatMeCount).setVisitorCount(visitorCount).setTotal(heartBeatMeCount + visitorCount);
    }

    @Override
    public void clearUnread(Long userId, UserClearUnReadDto dto) {
        LambdaUpdateWrapper lambdaUpdate = new LambdaUpdateWrapper();
        lambdaUpdate.eq(UserRelation::getUserId, (Object)userId);
        lambdaUpdate.in(UserRelation::getTargetUserId, dto.getTargetUserIds());
        lambdaUpdate.eq(UserRelation::getType, (Object)Constants.UserRelationType.HEARTBEAT.getType());
        lambdaUpdate.eq(UserRelation::getReadStatus, (Object)0);
        lambdaUpdate.set(UserRelation::getReadStatus, (Object)1);
        this.userRelationService.update((Wrapper)lambdaUpdate);
    }
}

