/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.contant.UserConstants;
import com.bxm.lovelink.common.dal.entity.InsertCard;
import com.bxm.lovelink.common.dal.entity.InsertCardContext;
import com.bxm.lovelink.common.dal.entity.MeetGroup;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.UserComposite;
import com.bxm.lovelink.common.dal.entity.UserLoveCondition;
import com.bxm.lovelink.common.dal.entity.UserOtherInfo;
import com.bxm.lovelink.common.dal.entity.UserRelation;
import com.bxm.lovelink.common.dal.entity.dto.matchmaker.MatchmakerRecommendQueryDto;
import com.bxm.lovelink.common.dal.entity.dto.matchmaker.RecommendMatchQueryDto;
import com.bxm.lovelink.common.dal.entity.vo.user.UserBasicInfoVo;
import com.bxm.lovelink.common.dal.entity.vo.user.UserCompositeSimpleVo;
import com.bxm.lovelink.common.dal.entity.vo.user.UserCompositeVo;
import com.bxm.lovelink.common.dal.mapper.UserBasicInfoMapper;
import com.bxm.lovelink.common.dal.mapping.UserInfoMapping;
import com.bxm.lovelink.common.dal.service.IMeetGroupService;
import com.bxm.lovelink.common.dal.service.IUserRelationService;
import com.bxm.lovelink.common.dal.service.IUserService;
import com.bxm.lovelink.common.dal.service.MatchmakerRecommendService;
import com.bxm.lovelink.common.dal.strategy.InsertCardStrategyFactory;
import com.bxm.lovelink.common.utils.GeoDistanceUtils;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.lovelink.integration.recommend.RecommendIntegration;
import com.bxm.lovelink.rs.facade.RecommendItem;
import com.bxm.lovelink.rs.facade.RecommendRequest;
import com.bxm.lovelink.rs.facade.RecommendResponse;
import com.bxm.lovelink.rs.facade.User;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.id.IdGenerator;
import com.bxm.warcar.utils.JsonHelper;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class MatchmakerRecommendServiceImpl
implements MatchmakerRecommendService {
    private static final Logger log = LoggerFactory.getLogger(MatchmakerRecommendServiceImpl.class);
    private final UserBasicInfoMapper userBasicInfoMapper;
    private final IUserService userService;
    private final Fetcher fetcher;
    private final InsertCardStrategyFactory insertCardStrategyFactory;
    private final RecommendIntegration recommendIntegration;
    private final IdGenerator idGenerator;
    private final Updater updater;
    private final IUserRelationService userRelationService;
    private final IMeetGroupService meetGroupService;

    @Override
    public IPage<UserCompositeSimpleVo> queryRecommendList(UserComposite userComposite, MatchmakerRecommendQueryDto recommendQueryDto) {
        Page page = new Page((long)recommendQueryDto.getCurrent(), (long)recommendQueryDto.getSize());
        UserBasicInfo loginBasicInfo = userComposite.getUserBasicInfo();
        if (Objects.isNull(loginBasicInfo.getGender())) {
            return MatchmakerRecommendServiceImpl.getDefaultPage((Page<UserCompositeSimpleVo>)page);
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("recommend");
        HashSet<String> excludeUserNumbers = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)recommendQueryDto.getExcludeUserNumbers())) {
            excludeUserNumbers = new HashSet(Lists.newArrayList((Object[])recommendQueryDto.getExcludeUserNumbers().split(",")));
        }
        RecommendRequest recommendRequest = this.buildRecommendRequest(loginBasicInfo, userComposite.getUserLoveCondition(), excludeUserNumbers);
        RecommendResponse recommendResponse = this.recommendIntegration.recommend(recommendRequest);
        stopWatch.stop();
        if (Objects.isNull(recommendResponse) || CollectionUtils.isEmpty((Collection)recommendResponse.getRecommendList())) {
            log.warn("queryRecommendList error recommendResponse is null, recommendRequest:{}", (Object)JsonHelper.convert((Object)recommendRequest));
            return MatchmakerRecommendServiceImpl.getDefaultPage((Page<UserCompositeSimpleVo>)page);
        }
        List recommendList = recommendResponse.getRecommendList();
        if (CollectionUtils.isEmpty(recommendList = recommendList.subList(0, Math.min(recommendQueryDto.getSize(), recommendList.size())))) {
            return MatchmakerRecommendServiceImpl.getDefaultPage((Page<UserCompositeSimpleVo>)page);
        }
        List<Long> userIdList = recommendList.stream().filter(Objects::nonNull).map(RecommendItem::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userIdList)) {
            return MatchmakerRecommendServiceImpl.getDefaultPage((Page<UserCompositeSimpleVo>)page);
        }
        stopWatch.start("getUserCompositeList");
        List<UserComposite> userCompositeList = this.getUserCompositeList(userIdList);
        stopWatch.stop();
        if (CollectionUtils.isEmpty(userCompositeList)) {
            return MatchmakerRecommendServiceImpl.getDefaultPage((Page<UserCompositeSimpleVo>)page);
        }
        userCompositeList = this.reorderUserCompositeList(userCompositeList, userIdList);
        stopWatch.start("insertSharedUserCard");
        this.insertSharedUserCard(loginBasicInfo, userCompositeList);
        stopWatch.stop();
        stopWatch.start("getUserCompositeSimpleVos");
        List<UserCompositeSimpleVo> simpleVoList = this.getUserCompositeSimpleVos(userCompositeList, loginBasicInfo);
        stopWatch.stop();
        stopWatch.start("handleInsertCard");
        this.handleInsertCard(loginBasicInfo, userComposite.getUserOtherInfo(), recommendQueryDto, simpleVoList);
        stopWatch.stop();
        page.setRecords(simpleVoList);
        log.info("queryRecommendList stopWatch:{}", (Object)stopWatch.prettyPrint());
        return page;
    }

    @Override
    public List<UserCompositeSimpleVo> getMatches(RecommendMatchQueryDto dto) {
        RecommendRequest recommendRequest;
        RecommendResponse recommendResponse;
        UserComposite userComposite = this.userService.getCompositeById(dto.getUserId());
        if (Objects.isNull(userComposite) || Objects.isNull(userComposite.getUserBasicInfo())) {
            return Collections.emptyList();
        }
        HashSet<String> excludeUserNumbers = new HashSet();
        if (CollectionUtils.isNotEmpty(dto.getExcludeUserNumbers())) {
            excludeUserNumbers = new HashSet<String>(dto.getExcludeUserNumbers());
        }
        if (Objects.isNull(recommendResponse = this.recommendIntegration.recommend(recommendRequest = this.buildRecommendRequest(userComposite.getUserBasicInfo(), userComposite.getUserLoveCondition(), excludeUserNumbers))) || CollectionUtils.isEmpty((Collection)recommendResponse.getRecommendList())) {
            return Collections.emptyList();
        }
        List recommendList = recommendResponse.getRecommendList();
        if (CollectionUtils.isEmpty(recommendList = recommendList.subList(0, Math.min(dto.getCount(), recommendList.size())))) {
            return Collections.emptyList();
        }
        List<Long> userIdList = recommendList.stream().filter(Objects::nonNull).map(RecommendItem::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userIdList)) {
            return Collections.emptyList();
        }
        List<UserComposite> userCompositeList = this.getUserCompositeList(userIdList);
        if (CollectionUtils.isEmpty(userCompositeList)) {
            return Collections.emptyList();
        }
        userCompositeList = this.reorderUserCompositeList(userCompositeList, userIdList);
        return this.getUserCompositeSimpleVos(userCompositeList, userComposite.getUserBasicInfo());
    }

    private List<UserComposite> reorderUserCompositeList(List<UserComposite> userCompositeList, List<Long> userIdList) {
        Map userMap = userCompositeList.stream().filter(Objects::nonNull).filter(u -> u.getUser() != null && u.getUser().getId() != null).collect(Collectors.toMap(u -> u.getUser().getId(), Function.identity(), (a, b) -> a));
        return userIdList.stream().map(userMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<UserComposite> getUserCompositeList(List<Long> userIdList) {
        try {
            return this.userService.getCompositePartByUserIdsFromCache(userIdList);
        }
        catch (Exception e) {
            log.warn("\u4ece\u7f13\u5b58\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u964d\u7ea7\u67e5\u8be2\u6570\u636e\u5e93\uff0cuserIds={}", userIdList, (Object)e);
            return this.userBasicInfoMapper.selectByIds(userIdList);
        }
    }

    private static Page<UserCompositeSimpleVo> getDefaultPage(Page<UserCompositeSimpleVo> page) {
        return page.setRecords((List)Lists.newArrayList((Object[])new UserCompositeSimpleVo[]{new UserCompositeSimpleVo().setCardType(2).setSwipeEffect(2)}));
    }

    private List<UserCompositeSimpleVo> getUserCompositeSimpleVos(List<UserComposite> userCompositeList, UserBasicInfo loginBasicInfo) {
        List<UserCompositeVo> convert = this.userService.convert(userCompositeList);
        convert.forEach(vo -> {
            if (Objects.nonNull(vo)) {
                UserBasicInfoVo basicInfo = vo.getUserBasicInfo();
                Double distance = GeoDistanceUtils.calculateDistance(loginBasicInfo.getLatitude(), loginBasicInfo.getLongitude(), basicInfo.getLatitude(), basicInfo.getLongitude());
                basicInfo.setDistance(distance);
                basicInfo.setSchoolName(Objects.equals(basicInfo.getSchoolHide(), 0) ? null : basicInfo.getSchoolName());
            }
        });
        return UserInfoMapping.INSTANCE.toList(convert);
    }

    private RecommendRequest buildRecommendRequest(UserBasicInfo userBasicInfo, UserLoveCondition userLoveCondition, Set<String> excludeUserNumbers) {
        List<MeetGroup> meetGroups;
        List<UserRelation> userRelations;
        RecommendRequest recommendRequest = new RecommendRequest();
        recommendRequest.setRequestId(this.idGenerator.next());
        recommendRequest.setContainUserInfo(true);
        User user = UserInfoMapping.INSTANCE.toRecommendUser(userBasicInfo);
        if (Objects.nonNull(userLoveCondition)) {
            user.setAgeRangeMax(userLoveCondition.getAgeRangeMax());
            user.setAgeRangeMin(userLoveCondition.getAgeRangeMin());
            user.setHeightRangeMin(userLoveCondition.getHeightRangeMin());
            user.setHeightRangeMax(userLoveCondition.getHeightRangeMax());
            if (!CollectionUtils.isEmpty(userLoveCondition.getEduRange())) {
                user.setEduRange(userLoveCondition.getEduRange());
            }
            if (!CollectionUtils.isEmpty(userLoveCondition.getYearRevenueRange())) {
                user.setYearRevenueRange(userLoveCondition.getYearRevenueRange());
            }
        }
        recommendRequest.setUser(user);
        if (CollectionUtils.isNotEmpty(excludeUserNumbers)) {
            recommendRequest.setExcludeUserNumbers(excludeUserNumbers);
        }
        if (CollectionUtils.isNotEmpty(userRelations = this.userRelationService.queryAll(user.getId()))) {
            ArrayList likeUserList = Lists.newArrayList();
            ArrayList dislikeUserList = Lists.newArrayList();
            for (UserRelation userRelation : userRelations) {
                if (Objects.equals(Constants.UserRelationType.HEARTBEAT.getType(), userRelation.getType())) {
                    likeUserList.add(userRelation.getTargetUserId());
                    continue;
                }
                if (!Objects.equals(Constants.UserRelationType.DISLIKE.getType(), userRelation.getType())) continue;
                dislikeUserList.add(userRelation.getTargetUserId());
            }
            user.setLikeUserList((List)likeUserList);
            user.setDislikeUserList((List)dislikeUserList);
        }
        if (CollectionUtils.isNotEmpty(meetGroups = this.meetGroupService.queryAll(user.getId()))) {
            user.setInviteUserList(meetGroups.stream().map(MeetGroup::getAcceptUserId).collect(Collectors.toList()));
        }
        return recommendRequest;
    }

    private void handleInsertCard(UserBasicInfo loginBasicInfo, UserOtherInfo userOtherInfo, MatchmakerRecommendQueryDto recommendQueryDto, List<UserCompositeSimpleVo> simpleVoList) {
        List<InsertCard> insertCards;
        String date = LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE);
        Integer todaySwipeCount = (Integer)Optional.ofNullable(this.fetcher.fetch(RedisKeys.swipeCountKey((Long)loginBasicInfo.getUserId(), (String)date), Integer.class)).orElse(0);
        InsertCardContext context = new InsertCardContext();
        context.setUserId(loginBasicInfo.getUserId());
        context.setTodaySwipeCount(todaySwipeCount);
        context.setRequestSize(simpleVoList.size());
        context.setUserInfoComplete(userOtherInfo.getBasicInfoGuideFinished().equals(1));
        context.setRealName(!CollectionUtils.isEmpty(loginBasicInfo.getCertStatus()) && loginBasicInfo.getCertStatus().contains(UserConstants.CertTypeEnum.REAL_PEOPLE.getCode()));
        if (StringUtils.isNotBlank((CharSequence)recommendQueryDto.getExcludeUserNumbers())) {
            context.setWaitSwipeCount(new HashSet(Lists.newArrayList((Object[])recommendQueryDto.getExcludeUserNumbers().split(","))).size());
        }
        if ((insertCards = this.insertCardStrategyFactory.computeAllInsertCards(context)).isEmpty()) {
            return;
        }
        HashSet<Integer> insertedPositions = new HashSet<Integer>();
        for (InsertCard card : insertCards) {
            int index = card.getIndex();
            Integer cardSubType = card.getCardSubType();
            if (index < 0 || index > simpleVoList.size()) continue;
            if (cardSubType == 3) {
                if (index >= simpleVoList.size()) continue;
                simpleVoList.get(index).setPopType(cardSubType).setSwipeEffect(1);
                continue;
            }
            if (!insertedPositions.add(index)) continue;
            simpleVoList.add(index, new UserCompositeSimpleVo().setCardType(cardSubType).setSwipeEffect(card.getSwipeEffect()));
        }
        for (int i = 0; i < simpleVoList.size(); ++i) {
            UserCompositeSimpleVo vo = simpleVoList.get(i);
            if (vo.getCardType() == null || vo.getCardType() != 2) continue;
            simpleVoList.subList(i + 1, simpleVoList.size()).clear();
            break;
        }
    }

    private void insertSharedUserCard(UserBasicInfo loginBasicInfo, List<UserComposite> userComposites) {
        String userId = (String)this.fetcher.fetch(RedisKeys.userFirstAppointDetailPage((Long)loginBasicInfo.getUserId()), String.class);
        if (StringUtils.isBlank((CharSequence)userId)) {
            return;
        }
        List<UserComposite> userCompositeList = this.getUserCompositeList(Collections.singletonList(Long.valueOf(userId)));
        if (CollectionUtils.isEmpty(userCompositeList)) {
            this.updater.remove(RedisKeys.userFirstAppointDetailPage((Long)loginBasicInfo.getUserId()));
            return;
        }
        UserComposite userComposite = userCompositeList.iterator().next();
        boolean shouldInsert = Optional.ofNullable(userComposite.getUserBasicInfo()).map(info -> !info.getGender().equals(loginBasicInfo.getGender())).orElse(false);
        if (shouldInsert) {
            userComposites.removeIf(vo -> userComposite.getUser().getId().equals(vo.getUser().getId()));
            userComposites.add(0, userComposite);
        }
        this.updater.remove(RedisKeys.userFirstAppointDetailPage((Long)loginBasicInfo.getUserId()));
    }

    public MatchmakerRecommendServiceImpl(UserBasicInfoMapper userBasicInfoMapper, IUserService userService, Fetcher fetcher, InsertCardStrategyFactory insertCardStrategyFactory, RecommendIntegration recommendIntegration, IdGenerator idGenerator, Updater updater, IUserRelationService userRelationService, IMeetGroupService meetGroupService) {
        this.userBasicInfoMapper = userBasicInfoMapper;
        this.userService = userService;
        this.fetcher = fetcher;
        this.insertCardStrategyFactory = insertCardStrategyFactory;
        this.recommendIntegration = recommendIntegration;
        this.idGenerator = idGenerator;
        this.updater = updater;
        this.userRelationService = userRelationService;
        this.meetGroupService = meetGroupService;
    }
}

