/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.dal.entity.Region;
import com.bxm.lovelink.common.dal.entity.vo.region.RegionVo;
import com.bxm.lovelink.common.dal.mapper.RegionMapper;
import com.bxm.lovelink.common.dal.mapping.RegionMapping;
import com.bxm.lovelink.common.dal.service.IRegionService;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.Target;
import com.bxm.warcar.xcache.TargetFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class RegionServiceImpl
extends ServiceImpl<RegionMapper, Region>
implements IRegionService {
    private final Fetcher fetcher;

    public RegionServiceImpl(Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public List<RegionVo> listByRootChildren() {
        return this.listByRoot().getChildren();
    }

    @Override
    public List<RegionVo> getByParentCode(Integer parentCode) {
        if (parentCode == null) {
            parentCode = 0;
        }
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(Region::getParentCode, (Object)parentCode));
        return RegionMapping.INSTANCE.doToVo(list);
    }

    @Override
    public RegionVo listByRoot() {
        Map<Integer, List<Region>> regions = this.list().stream().collect(Collectors.groupingBy(Region::getParentCode, Collectors.toList()));
        RegionVo root = new RegionVo().setCode(0);
        this.buildTree(root, regions);
        return root;
    }

    @Override
    public Map<Integer, String> queryByCodes(List<Integer> codes) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        if (CollectionUtils.isEmpty(codes)) {
            return result;
        }
        codes.removeIf(Objects::isNull);
        if (CollectionUtils.isEmpty(codes)) {
            return result;
        }
        HashSet<Integer> newCodes = new HashSet<Integer>(codes);
        for (Integer code : codes) {
            newCodes.add(code / 10000 * 10000);
            newCodes.add(code / 100 * 100);
        }
        return this.listByIds(newCodes).stream().collect(Collectors.toMap(Region::getCode, Region::getName));
    }

    @Override
    public <U> Map<Integer, U> fetchAll(Function<Region, U> valueMapper) {
        Target target = new TargetFactory().keyGenerator(() -> KeyBuilder.build((Object[])new Object[]{"lovelink", "region", "all"})).cls(Region.class).expireTimeInSecond(1800).listDataExtractor(() -> ((RegionServiceImpl)this).list()).build();
        List regions = this.fetcher.fetchToList(target);
        if (CollectionUtils.isEmpty((Collection)regions)) {
            return Collections.emptyMap();
        }
        return regions.stream().collect(Collectors.toMap(Region::getCode, valueMapper));
    }

    private void buildTree(RegionVo result, Map<Integer, List<Region>> regionMap) {
        List<Region> regions = regionMap.get(result.getCode());
        if (CollectionUtils.isEmpty(regions)) {
            return;
        }
        List<RegionVo> regionVos = RegionMapping.INSTANCE.doToVo(regions);
        result.setChildren(regionVos);
        for (RegionVo regionVo : regionVos) {
            this.buildTree(regionVo, regionMap);
        }
    }
}

