/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.bxm.lovelink.common.dal.service.ISensitiveService;
import com.bxm.lovelink.common.exception.BusinessException;
import com.bxm.lovelink.common.integration.sensitive.SensitiveImageIntegration;
import com.bxm.lovelink.common.integration.sensitive.SensitiveImageResult;
import com.bxm.lovelink.common.integration.sensitive.SensitiveTextIntegration;
import com.bxm.lovelink.common.integration.sensitive.SensitiveTextResult;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class SensitiveServiceImpl
implements ISensitiveService,
ApplicationListener<ApplicationReadyEvent> {
    private final List<SensitiveTextIntegration> textList = new ArrayList<SensitiveTextIntegration>();
    private final List<SensitiveImageIntegration> imageList = new ArrayList<SensitiveImageIntegration>();

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        this.textList.addAll(applicationContext.getBeansOfType(SensitiveTextIntegration.class).values());
        this.imageList.addAll(applicationContext.getBeansOfType(SensitiveImageIntegration.class).values());
    }

    @Override
    public SensitiveTextResult checkText(String text) {
        if (StringUtils.isBlank((String)text)) {
            return new SensitiveTextResult();
        }
        if (this.textList.isEmpty()) {
            throw new BusinessException("\u4e0d\u652f\u6301\u654f\u611f\u8bcd\u68c0\u6d4b");
        }
        return this.textList.get(0).checkText(text);
    }

    @Override
    public SensitiveImageResult checkImage(Integer type, String imageUrl) {
        if (StringUtils.isBlank((String)imageUrl)) {
            return new SensitiveImageResult();
        }
        if (this.imageList.isEmpty()) {
            throw new BusinessException("\u4e0d\u652f\u56fe\u7247\u68c0\u6d4b");
        }
        return this.imageList.get(0).checkImage(type, imageUrl);
    }
}

