/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.bxm.lovelink.common.dal.service.ISwipeControlService;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service
public class SwipeControlServiceImpl
implements ISwipeControlService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SwipeControlServiceImpl.class);
    private final JedisPool jedisPool;
    private String scriptSha;

    public SwipeControlServiceImpl(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public Integer doSwipe(String redisKey, Integer todayLimit, Long expireTime) {
        if (StringUtils.isBlank((CharSequence)redisKey) || Objects.isNull(todayLimit) || Objects.isNull(expireTime)) {
            log.error("\u6ed1\u52a8\u63a7\u5236\u53c2\u6570\u5f02\u5e38 redisKey={},todayLimit={},expireTime={}", new Object[]{redisKey, todayLimit, expireTime});
            return 1;
        }
        try (Jedis resource = this.jedisPool.getResource();){
            Long result = (Long)resource.evalsha(this.scriptSha, Collections.singletonList(redisKey), (List)Lists.newArrayList((Object[])new String[]{String.valueOf(todayLimit), String.valueOf(expireTime)}));
            Integer n = result.intValue();
            return n;
        }
    }

    public void afterPropertiesSet() {
        String script = "local key = KEYS[1]\nlocal todayLimit = tonumber(ARGV[1])\nlocal expireTime = tonumber(ARGV[2])\nlocal current = redis.call('INCR', key)\nif current == 1 then\n    redis.call('EXPIRE', key, expireTime)\nend\nif current > todayLimit then\n    return -1\nelseif current == todayLimit then\n    return 0\nelse\n    return 1\nend";
        try (Jedis resource = this.jedisPool.getResource();){
            this.scriptSha = resource.scriptLoad(script);
        }
    }
}

