/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.dal.entity.UserAudit;
import com.bxm.lovelink.common.dal.mapper.UserAuditMapper;
import com.bxm.lovelink.common.dal.service.IUserAuditService;
import com.bxm.lovelink.common.dal.user.audit.UserAuditHandlerManager;
import com.bxm.lovelink.common.push.Pusher;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class UserAuditServiceImpl
extends ServiceImpl<UserAuditMapper, UserAudit>
implements IUserAuditService {
    private static final Logger log = LoggerFactory.getLogger(UserAuditServiceImpl.class);
    private final UserAuditHandlerManager auditHandlerManager;
    private final ExecutorService executor;
    private final Pusher pusher;

    public UserAuditServiceImpl(UserAuditHandlerManager auditHandlerManager, @Lazy Pusher pusher) {
        this.auditHandlerManager = auditHandlerManager;
        this.pusher = pusher;
        this.executor = new ThreadPoolExecutor(20, 20, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("user_audit"));
    }

    @Override
    public void createAudit(UserAudit userAudit) {
        boolean save = this.save(userAudit);
        if (save) {
            this.audit(userAudit);
        }
    }

    @Override
    public void audit(UserAudit userAudit) {
        if (userAudit == null || userAudit.getId() == null) {
            return;
        }
        this.executor.execute(() -> {
            try {
                Integer status = this.auditHandlerManager.auditHandle(userAudit);
                this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UserAudit::getId, (Object)userAudit.getId())).eq(UserAudit::getAuditStatus, (Object)UserAudit.STATUS_WAIT)).set(UserAudit::getAuditStatus, (Object)status));
                if (Objects.equals(status, UserAudit.STATUS_FAIL)) {
                    PushTarget pushTarget = new PushTarget();
                    pushTarget.setUserId(userAudit.getUserId());
                    this.pusher.doImmediatePush(PushScene.HEAD_PICTURE_AUDIT_FAILE, pushTarget);
                }
            }
            catch (Exception e) {
                log.error("User audit error, userAudit:{}", (Object)JSON.toJSONString((Object)userAudit));
            }
        });
    }

    @Override
    public UserAudit getLastOneAudit(UserAudit userAudit) {
        if (userAudit == null) {
            return null;
        }
        if (userAudit.getId() != null) {
            return (UserAudit)this.getById(userAudit.getId());
        }
        return (UserAudit)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Objects.nonNull(userAudit.getConnectId()), UserAudit::getConnectId, (Object)userAudit.getConnectId())).eq(Objects.nonNull(userAudit.getUserId()), UserAudit::getUserId, (Object)userAudit.getUserId())).eq(Objects.nonNull(userAudit.getAuditBusiness()), UserAudit::getAuditBusiness, (Object)userAudit.getAuditBusiness())).eq(Objects.nonNull(userAudit.getAuditType()), UserAudit::getAuditType, (Object)userAudit.getAuditType())).orderByDesc(UserAudit::getId)).last("LIMIT 1"));
    }
}

