/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.dal.entity.UserAction;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.UserComposite;
import com.bxm.lovelink.common.dal.entity.UserRuleTag;
import com.bxm.lovelink.common.dal.entity.dto.user.UserBasicInfoDto;
import com.bxm.lovelink.common.dal.entity.dto.user.UserQueryDto;
import com.bxm.lovelink.common.dal.entity.vo.user.UserCompositeVo;
import com.bxm.lovelink.common.dal.mapper.UserBasicInfoMapper;
import com.bxm.lovelink.common.dal.mapping.UserInfoMapping;
import com.bxm.lovelink.common.dal.service.IUserBasicInfoService;
import com.bxm.lovelink.common.dal.service.IUserCertService;
import com.bxm.lovelink.common.dal.service.IUserLoveConditionService;
import com.bxm.lovelink.common.dal.service.IUserRuleTagService;
import com.bxm.lovelink.common.dal.service.IUserService;
import com.bxm.lovelink.common.dal.user.basicinfo.UserBasicInfoBuilderChain;
import com.bxm.lovelink.common.dal.user.basicinfo.UserBasicInfoBuilderContext;
import com.bxm.lovelink.common.enums.UserBasicInfoCompletionEnum;
import com.bxm.lovelink.common.event.promotion.UserActionEvent;
import com.bxm.lovelink.common.event.user.UserBasicInfoUpdateEvent;
import com.bxm.lovelink.common.event.user.UserCompleteStatusEvent;
import com.bxm.lovelink.common.exception.BusinessException;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.warcar.integration.eventbus.EventPark;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class UserBasicInfoServiceImpl
extends ServiceImpl<UserBasicInfoMapper, UserBasicInfo>
implements IUserBasicInfoService {
    private static final Logger log = LoggerFactory.getLogger(UserBasicInfoServiceImpl.class);
    private final IUserCertService userCertService;
    private final UserBasicInfoBuilderChain userBasicInfoBuilderChain;
    private final IUserService userService;
    private final RedissonClient redissonClient;
    private final IUserRuleTagService userRuleTagService;
    private final IUserLoveConditionService userLoveConditionService;
    private final EventPark eventPark;

    public UserBasicInfoServiceImpl(@Lazy IUserCertService userCertService, UserBasicInfoBuilderChain userBasicInfoBuilderChain, @Lazy IUserService userService, RedissonClient redissonClient, IUserRuleTagService userRuleTagService, @Lazy IUserLoveConditionService userLoveConditionService, EventPark eventPark) {
        this.userCertService = userCertService;
        this.userBasicInfoBuilderChain = userBasicInfoBuilderChain;
        this.userService = userService;
        this.redissonClient = redissonClient;
        this.userRuleTagService = userRuleTagService;
        this.userLoveConditionService = userLoveConditionService;
        this.eventPark = eventPark;
    }

    @Override
    public UserBasicInfo getOneByUserId(Long userId) {
        return (UserBasicInfo)this.getOne((Wrapper)new LambdaQueryWrapper().eq(UserBasicInfo::getUserId, (Object)userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateByDto(UserBasicInfoDto dto, UserComposite composite) {
        UserBasicInfo existingBasicInfo = composite.getUserBasicInfo();
        Long userId = existingBasicInfo.getUserId();
        RLock lock = this.redissonClient.getLock(RedisKeys.userBasicInfoUpdateLock((Long)userId).generateKey());
        boolean b = lock.tryLock();
        if (!b) {
            throw new BusinessException("\u4fe1\u606f\u66f4\u65b0\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        try {
            UserBasicInfo basicInfo = UserInfoMapping.INSTANCE.dtoToDo(dto);
            basicInfo.setId(existingBasicInfo.getId()).setUserId(userId);
            UserBasicInfoBuilderContext context = new UserBasicInfoBuilderContext().setUserComposite(composite).setExistBasicInfo(existingBasicInfo).setBasicInfoDto(dto);
            this.userBasicInfoBuilderChain.buildAndCheck(context, basicInfo);
            this.updateAndCalculateById(basicInfo);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateAndCalculateById(final UserBasicInfo entity) {
        boolean result = super.updateById((Object)entity);
        if (!result) {
            return false;
        }
        final UserBasicInfo userBasicInfo = (UserBasicInfo)this.getById(entity.getId());
        UserBasicInfo updateBasicInfo = new UserBasicInfo().setId(userBasicInfo.getId());
        final Integer completion = UserBasicInfoCompletionEnum.calculateCompletion(userBasicInfo);
        updateBasicInfo.setInfoCompleteProgress(completion);
        UserComposite userComposite = new UserComposite().setUserBasicInfo(userBasicInfo).setUserCerts(this.userCertService.getListNewByUserId(userBasicInfo.getUserId()));
        Map<Integer, UserRuleTag> map = this.userRuleTagService.calculate(userComposite);
        ArrayList<UserRuleTag> displayTag = new ArrayList<UserRuleTag>();
        ArrayList<UserRuleTag> hideTag = new ArrayList<UserRuleTag>();
        List<Object> hideTypes = new ArrayList();
        if (CollectionUtils.isNotEmpty(userBasicInfo.getHideTag())) {
            hideTypes = userBasicInfo.getHideTag().stream().map(UserRuleTag::getType).collect(Collectors.toList());
        }
        for (Map.Entry<Integer, UserRuleTag> entry : map.entrySet()) {
            if (hideTypes.contains(entry.getKey())) {
                hideTag.add(entry.getValue());
                continue;
            }
            displayTag.add(entry.getValue());
        }
        updateBasicInfo.setRuleTag(displayTag);
        updateBasicInfo.setHideTag(hideTag);
        super.updateById((Object)updateBasicInfo);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                UserBasicInfoServiceImpl.this.eventPark.post((EventObject)new UserActionEvent(this, new UserAction().setUserId(entity.getUserId()).setType(UserAction.REGISTER)));
                if (completion >= 80) {
                    UserBasicInfoServiceImpl.this.eventPark.post((EventObject)new UserActionEvent(this, new UserAction().setUserId(entity.getUserId()).setType(UserAction.INFO_COMPLETE)));
                }
                UserBasicInfoServiceImpl.this.eventPark.post((EventObject)new UserBasicInfoUpdateEvent(this, userBasicInfo.getUserId(), userBasicInfo));
                UserBasicInfoServiceImpl.this.eventPark.post((EventObject)new UserCompleteStatusEvent(this, userBasicInfo.getUserId()));
            }
        });
        return true;
    }

    @Override
    public void updateVipExpireTime(Long userId, int validDays) {
        if (validDays <= 0) {
            log.error("illegal validDays {}", (Object)validDays);
            return;
        }
        UserBasicInfo basicInfo = this.getOneByUserId(userId);
        LocalDateTime vipExpireTime = this.computeVipExpireTime(userId, validDays);
        UserBasicInfo userBasicInfo = new UserBasicInfo();
        userBasicInfo.setId(basicInfo.getId());
        userBasicInfo.setVipExpireTime(vipExpireTime);
        if (!this.updateById(userBasicInfo)) {
            throw new IllegalStateException("\u66f4\u65b0\u7528\u6237vip\u5230\u671f\u65f6\u95f4\u5931\u8d25");
        }
    }

    @Override
    public LocalDateTime computeVipExpireTime(Long userId, int validDays) {
        UserBasicInfo basicInfo = this.getOneByUserId(userId);
        LocalDateTime vipExpireTime = basicInfo.getVipExpireTime();
        LocalDateTime now = LocalDateTime.now();
        vipExpireTime = vipExpireTime == null || vipExpireTime.isBefore(LocalDateTime.now()) ? now.plusDays(validDays) : vipExpireTime.plusDays(validDays);
        return vipExpireTime;
    }

    @Override
    public IPage<UserCompositeVo> list(UserQueryDto dto) {
        LocalDate now = LocalDate.now();
        if (dto.getAgeMin() != null) {
            dto.setBirthdayEnd(now.minusYears(dto.getAgeMin().intValue()));
        }
        if (dto.getAgeMax() != null) {
            dto.setBirthdayStart(now.minusYears(dto.getAgeMax().intValue()));
        }
        Page<UserComposite> compositePage = ((UserBasicInfoMapper)this.baseMapper).queryList((Page<Object>)new Page((long)dto.getCurrent(), (long)dto.getSize()), dto);
        Page<UserCompositeVo> voPage = UserInfoMapping.INSTANCE.toUserPage((IPage<UserComposite>)compositePage);
        voPage.setRecords(this.userService.convert(compositePage.getRecords()));
        return voPage;
    }

    @Override
    public List<UserBasicInfo> listByUserIds(List<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyList();
        }
        return ((UserBasicInfoMapper)this.baseMapper).selectList((Wrapper)new LambdaQueryWrapper().in(UserBasicInfo::getUserId, userIds));
    }

    @Override
    public List<UserBasicInfo> listIncludeDeleted(List<Long> userIds) {
        return ((UserBasicInfoMapper)this.baseMapper).listIncludeDeleted(userIds);
    }
}

