/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.contant.UserConstants;
import com.bxm.lovelink.common.dal.entity.UserAction;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.UserCert;
import com.bxm.lovelink.common.dal.entity.UserCertPeople;
import com.bxm.lovelink.common.dal.mapper.UserCertMapper;
import com.bxm.lovelink.common.dal.service.IUserBasicInfoService;
import com.bxm.lovelink.common.dal.service.IUserCertService;
import com.bxm.lovelink.common.event.promotion.UserActionEvent;
import com.bxm.lovelink.common.event.user.UserCompleteStatusEvent;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.lovelink.integration.identify.IdentifyIntegration;
import com.bxm.lovelink.integration.identify.IdentifyResult;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.bxm.warcar.utils.JsonHelper;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserCertServiceImpl
extends ServiceImpl<UserCertMapper, UserCert>
implements IUserCertService {
    private static final Logger log = LoggerFactory.getLogger(UserCertServiceImpl.class);
    private final IUserBasicInfoService userBasicInfoService;
    private final RedissonClient redissonClient;
    private final IdentifyIntegration identifyIntegration;
    private final EventPark eventPark;

    public UserCertServiceImpl(IUserBasicInfoService userBasicInfoService, RedissonClient redissonClient, IdentifyIntegration identifyIntegration, EventPark eventPark) {
        this.userBasicInfoService = userBasicInfoService;
        this.redissonClient = redissonClient;
        this.identifyIntegration = identifyIntegration;
        this.eventPark = eventPark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cert(UserCert userCert) {
        if (userCert == null || userCert.getUserId() == null || userCert.getCertType() == null) {
            throw new IllegalArgumentException("\u8ba4\u8bc1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RLock lock = this.redissonClient.getLock(RedisKeys.userCertLock((Long)userCert.getUserId(), (Integer)userCert.getCertType()).generateKey());
        boolean b = lock.tryLock();
        if (!b) {
            throw new IllegalArgumentException("\u8ba4\u8bc1\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        try {
            this.check(userCert.getUserId(), userCert.getCertType());
            this.save(userCert);
            this.updateCertProgress(userCert.getUserId());
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateCertByApi(UserCert userCert) {
        if (userCert == null) {
            return;
        }
        if (!userCert.isByApi() || !userCert.isWaiting()) {
            return;
        }
        RLock lock = this.redissonClient.getLock(RedisKeys.userCertLock((Long)userCert.getUserId(), (Integer)userCert.getCertType()).generateKey());
        boolean b = lock.tryLock();
        if (!b) {
            throw new IllegalArgumentException("\u8ba4\u8bc1\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        try {
            UserCertPeople certPeople = (UserCertPeople)JsonHelper.convert((String)userCert.getCertContent(), UserCertPeople.class);
            IdentifyResult identifyResult = this.identifyIntegration.queryResult(certPeople.getName(), certPeople.getCardNumber(), userCert.getCertType());
            userCert.setCertResult(identifyResult.getCertResult());
            userCert.setCertStatus(identifyResult.isSuccess() ? UserCert.STATUS_PASS : UserCert.STATUS_FAIL);
            this.updateById(userCert);
            this.updateCertProgress(userCert.getUserId());
            if (identifyResult.isSuccess()) {
                if (userCert.getCertType().equals(UserConstants.CertTypeEnum.EDU.getCode())) {
                    this.eventPark.post((EventObject)new UserActionEvent(this, new UserAction().setUserId(userCert.getUserId()).setType(UserAction.EDUCATION).setEduHighest(userCert.getEduHighest())));
                }
                if (userCert.getCertType().equals(UserConstants.CertTypeEnum.MARRIED.getCode()) && userCert.isUnMarried()) {
                    this.eventPark.post((EventObject)new UserActionEvent(this, new UserAction().setUserId(userCert.getUserId()).setType(UserAction.MARRIAGE)));
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void updateCertProgress(Long userId) {
        List<UserCert> userCerts = this.getListNewByUserId(userId);
        int size = UserConstants.CertTypeEnum.getNeededCertTypes().size();
        int count = 0;
        ArrayList<Integer> certStatus = new ArrayList<Integer>();
        for (UserCert value : userCerts) {
            if (value.isSuccess()) {
                ++count;
            }
            if (!value.isSuccessWithCarNum()) continue;
            certStatus.add(value.getCertType());
        }
        int percent = size == count ? 100 : 100 / size * count;
        UserBasicInfo basicInfo = this.userBasicInfoService.getOneByUserId(userId);
        Integer trustPercent = this.computeTrustPercent(userCerts, basicInfo);
        this.userBasicInfoService.updateById(new UserBasicInfo().setId(basicInfo.getId()).setInfoCertProgress(percent).setTrustPercent(trustPercent).setCertStatus(certStatus));
        this.eventPark.post((EventObject)new UserCompleteStatusEvent(this, userId));
    }

    @Override
    public List<UserCert> getListByUserId(Long userId) {
        return this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UserCert::getUserId, (Object)userId)).orderByDesc(UserCert::getId));
    }

    @Override
    public List<UserCert> getListNewByUserId(Long userId) {
        Map<Integer, UserCert> map = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UserCert::getUserId, (Object)userId)).orderByDesc(UserCert::getId)).stream().collect(Collectors.groupingBy(UserCert::getCertType, Collectors.collectingAndThen(Collectors.toList(), x -> x.isEmpty() ? null : (UserCert)x.get(0))));
        return new ArrayList<UserCert>(map.values());
    }

    @Override
    public UserCert getOneByUserIdAndType(Long userId, Integer type) {
        return (UserCert)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UserCert::getUserId, (Object)userId)).eq(UserCert::getCertType, (Object)type)).orderByDesc(UserCert::getId)).last("LIMIT 1"));
    }

    @Override
    public void check(Long userId, Integer type) {
        UserCert userCert = this.getOneByUserIdAndType(userId, type);
        if (userCert == null) {
            return;
        }
        if (userCert.isWaiting()) {
            throw new IllegalArgumentException("\u8ba4\u8bc1\u4e2d\uff0c\u8bf7\u7b49\u5f85\u8ba4\u8bc1\u7ed3\u679c");
        }
        if (userCert.isSuccess() && userCert.isRealName()) {
            throw new IllegalArgumentException("\u8ba4\u8bc1\u5df2\u7ecf\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u8ba4\u8bc1");
        }
    }

    private Integer computeTrustPercent(List<UserCert> userCerts, UserBasicInfo basicInfo) {
        List<Integer> neededCertTypes = UserConstants.CertTypeEnum.getNeededCertTypes();
        if (basicInfo.declareNoCar()) {
            neededCertTypes.remove(UserConstants.CertTypeEnum.CAR.getCode());
            userCerts.removeIf(c -> UserConstants.CertTypeEnum.CAR.getCode().equals(c.getCertType()));
        }
        int count = 0;
        for (UserCert value : userCerts) {
            if (!value.isSuccessWithCarNum()) continue;
            ++count;
        }
        int size = neededCertTypes.size();
        int trustPercent = size == count ? 99 : (count * 99 + (size - count) * 50) / size;
        return trustPercent;
    }
}

