/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.dal.entity.UserComposite;
import com.bxm.lovelink.common.dal.entity.UserLoveCondition;
import com.bxm.lovelink.common.dal.entity.dto.user.UserLoveConditionDto;
import com.bxm.lovelink.common.dal.mapper.UserLoveConditionMapper;
import com.bxm.lovelink.common.dal.mapping.UserInfoMapping;
import com.bxm.lovelink.common.dal.service.IUserLoveConditionService;
import com.bxm.lovelink.common.enums.UserLoveConditionCompletionEnum;
import com.bxm.lovelink.common.event.user.UserCompleteStatusEvent;
import com.bxm.warcar.integration.eventbus.EventPark;
import java.util.EventObject;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class UserLoveConditionServiceImpl
extends ServiceImpl<UserLoveConditionMapper, UserLoveCondition>
implements IUserLoveConditionService {
    private final EventPark eventPark;

    @Override
    public UserLoveCondition getOneByUserId(Long userId) {
        return (UserLoveCondition)this.getOne((Wrapper)new LambdaQueryWrapper().eq(UserLoveCondition::getUserId, (Object)userId));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateByDto(UserLoveConditionDto dto, UserComposite composite) {
        UserLoveCondition condition = composite.getUserLoveCondition();
        UserLoveCondition userLoveCondition = UserInfoMapping.INSTANCE.dtoToDo(dto);
        userLoveCondition.setId(condition.getId());
        this.updateById(userLoveCondition);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateById(UserLoveCondition entity) {
        boolean result = super.updateById((Object)entity);
        if (!result) {
            return false;
        }
        final UserLoveCondition loveCondition = (UserLoveCondition)this.getById(entity.getId());
        Integer completion = UserLoveConditionCompletionEnum.calculateCompletion(loveCondition);
        super.updateById((Object)new UserLoveCondition().setId(entity.getId()).setInfoCompleteProgress(completion));
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                UserLoveConditionServiceImpl.this.eventPark.post((EventObject)new UserCompleteStatusEvent(this, loveCondition.getUserId()));
            }
        });
        return true;
    }

    public UserLoveConditionServiceImpl(EventPark eventPark) {
        this.eventPark = eventPark;
    }
}

