/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.dal.entity.UserMeetTicket;
import com.bxm.lovelink.common.dal.entity.UserMeetTicketRecord;
import com.bxm.lovelink.common.dal.entity.UserOrder;
import com.bxm.lovelink.common.dal.entity.UserTicketRecordExt;
import com.bxm.lovelink.common.dal.entity.dto.meetticket.ReturnTicketOperateDto;
import com.bxm.lovelink.common.dal.entity.dto.meetticket.TicketFinishGiveOperateDto;
import com.bxm.lovelink.common.dal.entity.dto.meetticket.TicketOperateDto;
import com.bxm.lovelink.common.dal.mapper.UserMeetTicketMapper;
import com.bxm.lovelink.common.dal.service.IUserMeetTicketRecordService;
import com.bxm.lovelink.common.dal.service.IUserMeetTicketService;
import com.bxm.lovelink.common.dal.service.IUserOrderService;
import com.bxm.lovelink.common.dal.service.IUserOtherInfoService;
import com.bxm.lovelink.common.enums.TicketRecordTypeEnum;
import com.bxm.lovelink.common.enums.TicketReturnTypeEnum;
import com.bxm.lovelink.common.exception.BusinessException;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserMeetTicketServiceImpl
extends ServiceImpl<UserMeetTicketMapper, UserMeetTicket>
implements IUserMeetTicketService {
    private final IUserMeetTicketRecordService ticketRecordService;
    private IUserOrderService userOrderService;
    private final IUserOtherInfoService otherInfoService;

    public UserMeetTicketServiceImpl(IUserMeetTicketRecordService ticketRecordService, IUserOtherInfoService otherInfoService) {
        this.ticketRecordService = ticketRecordService;
        this.otherInfoService = otherInfoService;
    }

    @Autowired
    public void setUserOrderService(IUserOrderService userOrderService) {
        this.userOrderService = userOrderService;
    }

    @Override
    public void rechargeTicket(TicketOperateDto dto) {
        Preconditions.checkArgument((dto.getType() != null ? 1 : 0) != 0, (Object)"\u7f3a\u5c11type\u53c2\u6570");
        Long orderId = dto.getConnectId();
        UserOrder userOrder = (UserOrder)this.userOrderService.getById(orderId);
        if (Objects.isNull(userOrder)) {
            throw new IllegalStateException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (userOrder.getStatus() != 2) {
            throw new IllegalStateException("\u8ba2\u5355\u672a\u652f\u4ed8\u6210\u529f");
        }
        this.save(new UserMeetTicket().setUserId(dto.getUserId()).setMeetTicketProductId(userOrder.getMeetTicketProductId()).setMeetTicketProductName(userOrder.getProductName()).setTotalAmount(dto.getAmount()).setRemainAmount(dto.getAmount()).setExpireTime(LocalDateTime.now().plusDays(1095L)).setTicketId(UUID.randomUUID().toString()).setPrice(userOrder.getPaymentAmount()).setStatus(UserMeetTicket.STATUS_AVAILABLE));
        JSONObject productExtObj = JSONObject.parseObject((String)userOrder.getProductExtJson());
        UserTicketRecordExt userTicketRecordExt = new UserTicketRecordExt().setTitle(userOrder.getProductName()).setDetailTitle(userOrder.getProductName()).setDescription(userOrder.getProductName()).setVipExpireTime(productExtObj.getString("vipExpireTime")).setTicketExpireTime(LocalDateTime.now().plusDays(1095L)).setInviteTime(LocalDateTime.now()).setRemark(String.format("\u7ea2\u8c46\u6709\u6548\u671f%s\u5929", 1095));
        this.saveRecord(dto.getUserId(), dto.getAmount(), dto.getConnectId(), userTicketRecordExt, dto.getType());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=20)
    public void giveTicket(TicketFinishGiveOperateDto dto) {
        TicketRecordTypeEnum type = dto.getType();
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"\u7f3a\u5c11type\u53c2\u6570");
        LocalDateTime expireTime = LocalDateTime.now().plusDays(1095L);
        this.save(new UserMeetTicket().setUserId(dto.getUserId()).setTotalAmount(dto.getAmount()).setRemainAmount(dto.getAmount()).setExpireTime(expireTime).setTicketId(UUID.randomUUID().toString()).setPrice(BigDecimal.ZERO).setStatus(UserMeetTicket.STATUS_AVAILABLE));
        UserTicketRecordExt userTicketRecordExt = new UserTicketRecordExt().setTitle("\u5e73\u53f0\u8d60\u9001").setDetailTitle(String.format("\u5e73\u53f0\u8d60\u9001%s\u9897\u7ea2\u8c46", dto.getAmount())).setDescription(String.format("%s \u8d60\u9001%s\u9897\u7ea2\u8c46", type.getDesc(), dto.getAmount())).setTicketExpireTime(expireTime).setInviteTime(LocalDateTime.now()).setRemark(String.format("\u7ea2\u8c46\u6709\u6548\u671f%s\u5929", 1095));
        this.saveRecord(dto.getUserId(), dto.getAmount(), dto.getConnectId(), userTicketRecordExt, type);
        this.otherInfoService.updateInfoFinishGiveStage(dto.getUserId(), dto.getStage());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=20)
    public List<Long> useTicket(TicketOperateDto dto) {
        int remainAmount = this.getUserRemainAmount(dto.getUserId());
        if (remainAmount < dto.getAmount()) {
            throw new IllegalStateException("\u6ca1\u6709\u8db3\u591f\u7684\u7ea2\u8c46");
        }
        this.minus(dto.getUserId(), dto.getAmount());
        UserTicketRecordExt ext = new UserTicketRecordExt().setTitle(dto.getRemark() + " \u652f\u51fa").setDescription(dto.getRemark() + String.format(" \u652f\u4ed8%s\u9897\u7ea2\u8c46", dto.getAmount())).setInviteContent(dto.getRemark()).setRemark(String.format("\u8d85\u8fc7%s\u5c0f\u65f6\u672a\u786e\u8ba4\uff0c\u7ea2\u8c46\u5c06\u81ea\u52a8\u9000\u56de", 48)).setInviteTime(LocalDateTime.now());
        this.saveRecord(dto.getUserId(), dto.getAmount(), dto.getConnectId(), ext, TicketRecordTypeEnum.USE);
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=10)
    public void returnTicket(ReturnTicketOperateDto dto) {
        Integer amount = dto.getAmount();
        if (TicketReturnTypeEnum.REFUSE.equals((Object)dto.getReturnType())) {
            amount = (int)Math.ceil((double)amount.intValue() * 0.8);
        }
        this.plus(dto.getUserId(), amount);
        UserMeetTicketRecord relateUseInfo = (UserMeetTicketRecord)this.ticketRecordService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UserMeetTicketRecord::getUserId, (Object)dto.getUserId())).eq(UserMeetTicketRecord::getType, (Object)TicketRecordTypeEnum.USE.getOrdinal())).eq(UserMeetTicketRecord::getConnectId, (Object)dto.getConnectId()));
        if (Objects.isNull(relateUseInfo)) {
            throw new IllegalStateException("\u9000\u7ea2\u8c46\u65f6\u65e0\u6cd5\u627e\u5230\u5173\u8054\u7684\u652f\u51fa\u4fe1\u606f - " + dto.getConnectId());
        }
        UserTicketRecordExt relateInfoExt = relateUseInfo.getExtJson();
        String inviteInfo = relateInfoExt.getInviteContent();
        UserTicketRecordExt userTicketRecordExt = new UserTicketRecordExt().setTitle(inviteInfo + " " + dto.getReturnType().getDesc() + " \u9000\u7ea2\u8c46").setDetailTitle(String.format("\u9000%s\u9897\u7ea2\u8c46", amount)).setDescription(relateInfoExt.getDescription()).setReturnReason(dto.getReturnType().getDesc()).setInviteTime(relateInfoExt.getInviteTime()).setReturnTime(LocalDateTime.now());
        this.saveRecord(dto.getUserId(), amount, dto.getConnectId(), userTicketRecordExt, TicketRecordTypeEnum.RETURN);
    }

    @Override
    public List<UserMeetTicket> listAvailableTicket(Long userId) {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UserMeetTicket::getUserId, (Object)userId)).eq(UserMeetTicket::getStatus, (Object)UserMeetTicket.STATUS_AVAILABLE)).gt(UserMeetTicket::getExpireTime, (Object)LocalDateTime.now()));
    }

    @Override
    public int getUserRemainAmount(Long userId) {
        List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UserMeetTicket::getUserId, (Object)userId)).eq(UserMeetTicket::getStatus, (Object)UserMeetTicket.STATUS_AVAILABLE)).gt(UserMeetTicket::getExpireTime, (Object)LocalDateTime.now()));
        return list.stream().mapToInt(UserMeetTicket::getRemainAmount).sum();
    }

    private void minus(Long userId, Integer value) {
        if (value <= 0) {
            throw new IllegalArgumentException("\u6570\u91cf\u9519\u8bef");
        }
        LocalDateTime time = LocalDateTime.now();
        while (true) {
            UserMeetTicket meetTicket;
            if ((meetTicket = ((UserMeetTicketMapper)this.baseMapper).selectUserAvailableTicket(userId, time)) == null) {
                throw new BusinessException("\u7ea2\u8c46\u4e0d\u8db3");
            }
            Integer current = meetTicket.getRemainAmount();
            if (((UserMeetTicketMapper)this.baseMapper).optimismUpdateAmount(meetTicket.getId(), current - value, current) > 0) {
                return;
            }
            if (((UserMeetTicketMapper)this.baseMapper).optimismUpdateAmount(meetTicket.getId(), 0, current) <= 0) continue;
            value = value - current;
        }
    }

    private void plus(Long userId, Integer value) {
        boolean ret;
        UserMeetTicket ticket = ((UserMeetTicketMapper)this.baseMapper).selectUserLastUsedTicket(userId, LocalDateTime.now());
        if (Objects.isNull(ticket)) {
            throw new BusinessException("Plus ticket is null");
        }
        boolean bl = ret = ((UserMeetTicketMapper)this.baseMapper).optimismUpdateAmount(ticket.getId(), ticket.getRemainAmount() + value, ticket.getRemainAmount()) > 0;
        if (!ret) {
            throw new BusinessException("Ticket plus fail");
        }
    }

    private void saveRecord(Long userId, Integer amount, Long connectId, UserTicketRecordExt userTicketRecordExt, TicketRecordTypeEnum type) {
        this.ticketRecordService.save(new UserMeetTicketRecord().setUserId(userId).setAmount(amount).setConnectId(connectId).setType(type.getOrdinal()).setCategory(type.getCategory()).setExtJson(userTicketRecordExt));
    }
}

