/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.bxm.lovelink.common.autoconfigure.LoginApiOnlineProperties;
import com.bxm.lovelink.common.dal.service.IUserOnlineService;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service
public class UserOnlineServiceImpl
implements IUserOnlineService {
    private final Fetcher fetcher;
    private final Updater updater;
    private final JedisPool jedisPool;
    private final LoginApiOnlineProperties properties;

    @Override
    public Boolean getOnline(Long userId) {
        return this.compareOnline(this.getLastOnlineTime(userId));
    }

    @Override
    public void recordLastOnlineTime(Long userId) {
        this.updater.update(RedisKeys.userActiveTime((Long)userId), (Object)LocalDateTimeUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss"), this.properties.getKeepAliveTimeInSec().intValue());
    }

    @Override
    public Map<Long, Boolean> getBatchOnline(List<Long> userIds) {
        Map<Long, LocalDateTime> batchLastOnlineTime = this.getBatchLastOnlineTime(userIds);
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>();
        batchLastOnlineTime.forEach((k, v) -> result.put((Long)k, this.compareOnline((LocalDateTime)v)));
        return result;
    }

    @Override
    public LocalDateTime getLastOnlineTime(Long userId) {
        return this.parse((String)this.fetcher.fetch(RedisKeys.userActiveTime((Long)userId), String.class));
    }

    @Override
    public Map<Long, LocalDateTime> getBatchLastOnlineTime(List<Long> userIds) {
        List values;
        HashMap<Long, LocalDateTime> map = new HashMap<Long, LocalDateTime>();
        if (CollectionUtils.isEmpty(userIds)) {
            return map;
        }
        ArrayList keys = Lists.newArrayList();
        userIds.forEach(x -> keys.add(RedisKeys.userActiveTime((Long)x).generateKey()));
        try (Jedis jedis = this.jedisPool.getResource();){
            values = jedis.mget(keys.toArray(new String[0]));
        }
        for (int i = 0; i < userIds.size(); ++i) {
            map.put(userIds.get(i), this.parse((String)values.get(i)));
        }
        return map;
    }

    private LocalDateTime parse(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return LocalDateTimeUtil.parse((CharSequence)value, (String)"yyyy-MM-dd HH:mm:ss");
    }

    private Boolean compareOnline(LocalDateTime lastOnlineTime) {
        if (lastOnlineTime == null) {
            return false;
        }
        return LocalDateTimeUtil.between((LocalDateTime)lastOnlineTime, (LocalDateTime)LocalDateTime.now(), (ChronoUnit)ChronoUnit.SECONDS) <= (long)this.properties.getOnlineTimeInSec().intValue();
    }

    public UserOnlineServiceImpl(Fetcher fetcher, Updater updater, JedisPool jedisPool, LoginApiOnlineProperties properties) {
        this.fetcher = fetcher;
        this.updater = updater;
        this.jedisPool = jedisPool;
        this.properties = properties;
    }
}

