/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.LoveLinkGlobalConfig;
import com.bxm.lovelink.common.dal.entity.ActivityRegistration;
import com.bxm.lovelink.common.dal.entity.MeetTicketProduct;
import com.bxm.lovelink.common.dal.entity.UserAction;
import com.bxm.lovelink.common.dal.entity.UserCert;
import com.bxm.lovelink.common.dal.entity.UserOrder;
import com.bxm.lovelink.common.dal.entity.dto.meetticket.TicketOperateDto;
import com.bxm.lovelink.common.dal.entity.dto.order.CreateOrderDto;
import com.bxm.lovelink.common.dal.entity.dto.order.PrepayDto;
import com.bxm.lovelink.common.dal.mapper.UserOrderMapper;
import com.bxm.lovelink.common.dal.service.IActivityRegistrationService;
import com.bxm.lovelink.common.dal.service.IMeetTicketProductService;
import com.bxm.lovelink.common.dal.service.IUserBasicInfoService;
import com.bxm.lovelink.common.dal.service.IUserCertService;
import com.bxm.lovelink.common.dal.service.IUserMeetTicketService;
import com.bxm.lovelink.common.dal.service.IUserOrderService;
import com.bxm.lovelink.common.enums.TicketRecordTypeEnum;
import com.bxm.lovelink.common.event.promotion.UserActionEvent;
import com.bxm.lovelink.common.exception.BusinessException;
import com.bxm.lovelink.integration.apple.ApplePayIntegration;
import com.bxm.lovelink.integration.pay.PayIntegration;
import com.bxm.lovelink.integration.pay.facade.PayOrder;
import com.bxm.warcar.id.IdGenerator;
import com.bxm.warcar.integration.eventbus.EventPark;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserOrderServiceImpl
extends ServiceImpl<UserOrderMapper, UserOrder>
implements IUserOrderService {
    private static final Logger log = LoggerFactory.getLogger(UserOrderServiceImpl.class);
    private final IMeetTicketProductService meetTicketProductService;
    private final PayIntegration payIntegration;
    private final LoveLinkGlobalConfig loveLinkGlobalConfig;
    private final IUserBasicInfoService userBasicInfoService;
    private IUserMeetTicketService userMeetTicketService;
    private IdGenerator idGenerator;
    private final EventPark eventPark;
    private final IUserCertService userCertService;
    private final IActivityRegistrationService activityRegistrationService;

    public UserOrderServiceImpl(IMeetTicketProductService meetTicketProductService, PayIntegration payIntegration, LoveLinkGlobalConfig loveLinkGlobalConfig, IUserBasicInfoService userBasicInfoService, EventPark eventPark, IUserCertService userCertService, @Lazy IActivityRegistrationService activityRegistrationService) {
        this.meetTicketProductService = meetTicketProductService;
        this.payIntegration = payIntegration;
        this.loveLinkGlobalConfig = loveLinkGlobalConfig;
        this.userBasicInfoService = userBasicInfoService;
        this.eventPark = eventPark;
        this.userCertService = userCertService;
        this.activityRegistrationService = activityRegistrationService;
    }

    @Autowired
    @Qualifier(value="orderIdGenerator")
    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Autowired
    public void setMeetTicketProductService(IUserMeetTicketService userMeetTicketService) {
        this.userMeetTicketService = userMeetTicketService;
    }

    @Override
    public UserOrder query(String orderNum) {
        return (UserOrder)this.getOne((Wrapper)Wrappers.query((Object)new UserOrder().setOrderNum(orderNum)));
    }

    @Override
    public String createOrder(CreateOrderDto dto, Long userId) {
        String orderNum;
        UserOrder order;
        MeetTicketProduct product = (MeetTicketProduct)this.meetTicketProductService.getById(dto.getMeetTicketProductId());
        if (product == null) {
            throw new IllegalArgumentException("\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(product.getStatus(), 0)) {
            throw new IllegalArgumentException("\u5546\u54c1\u5df2\u4e0b\u67b6");
        }
        if (Objects.equals(product.getProductType(), 3) && (StringUtils.isBlank((CharSequence)dto.getExtJson()) || !JSONObject.parseObject((String)dto.getExtJson()).containsKey((Object)"certType"))) {
            throw new IllegalArgumentException("\u672a\u627e\u5230certType");
        }
        JSONObject ext = new JSONObject();
        if (Objects.equals(1, product.getProductType()) || Objects.equals(2, product.getProductType())) {
            ext.put("ticketValidDays", (Object)product.getTicketValidDays());
            if (product.getVipValidDays() != null) {
                LocalDateTime vipExpireTime = this.userBasicInfoService.computeVipExpireTime(userId, product.getVipValidDays());
                ext.put("vipExpireTime", (Object)vipExpireTime);
                ext.put("vipValidDays", (Object)product.getVipValidDays());
            }
        }
        if (!this.save(order = new UserOrder().setOrderNum(orderNum = this.idGenerator.next()).setUserId(userId).setMeetTicketProductId(dto.getMeetTicketProductId()).setChannel(dto.getChannel()).setProductAmount(product.getAmount()).setProductType(product.getProductType()).setProductName(product.getName()).setProductDesc(product.getDescription()).setTotalPrice(product.getDiscountPrice()).setPaymentAmount(BigDecimal.ZERO).setStatus(0).setProductExtJson(ext.toJSONString()).setExtJson(dto.getExtJson()))) {
            throw new IllegalStateException("\u4e0b\u5355\u5931\u8d25");
        }
        return orderNum;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public Object prepay(PrepayDto prepayDto) {
        boolean isNotAvailablePrepayStatus;
        String orderNum = prepayDto.getOrderNum();
        UserOrder order = this.query(orderNum);
        if (Objects.isNull(order)) {
            throw new IllegalArgumentException("\u652f\u4ed8\u7684\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        Integer status = order.getStatus();
        boolean bl = isNotAvailablePrepayStatus = status > 1;
        if (isNotAvailablePrepayStatus) {
            throw new IllegalStateException("\u8ba2\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u652f\u4ed8");
        }
        order.setPayType(prepayDto.getPayType());
        order.setStatus(1);
        if (!this.updateById(order)) {
            log.error("\u8ba2\u5355\u66f4\u65b0\u5931\u8d25\u4e86 orderNum:{}", (Object)orderNum);
        }
        if (prepayDto.isApplePay()) {
            return null;
        }
        PayOrder payOrder = new PayOrder().setOrderNum(orderNum).setAmount(order.getTotalPrice()).setPayType(prepayDto.getPayType()).setSubject(order.getProductName()).setBody(orderNum).setClientType(Integer.valueOf(prepayDto.getClientType())).setOpenId(prepayDto.getOpenId()).setClientIp(prepayDto.getClientIp()).setReboundUrl(prepayDto.getReboundUrl()).setNotifyUrl(this.loveLinkGlobalConfig.getPayNotifyUrl());
        return this.payIntegration.pay(payOrder);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=30)
    public void delivery(String orderNum, String paymentId, BigDecimal amount) {
        ActivityRegistration activityRegistration;
        UserOrder order = this.query(orderNum);
        if (Objects.isNull(order)) {
            log.error("\u8ba2\u5355\u652f\u4ed8\u6210\u529f\uff0c\u4ea4\u4ed8\u9636\u6bb5\u8ba2\u5355\u4e0d\u5b58\u5728\uff1a{}", (Object)orderNum);
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)updateWrapper.set((Object)"payment_id", (Object)paymentId)).set((Object)"payment_amount", (Object)amount)).set((Object)"status", (Object)2)).set((Object)"payment_time", (Object)LocalDateTime.now())).eq((Object)"order_num", (Object)orderNum)).eq((Object)"status", (Object)1);
        if (!this.update((Wrapper)updateWrapper)) {
            if (1 != order.getStatus()) {
                log.warn("{} - \u72b6\u6001\u8ba2\u5355\u662f {}\uff0c\u4e0d\u8fdb\u884c\u5904\u7406\u3002", (Object)orderNum, (Object)order.getStatus());
                return;
            }
            throw new IllegalStateException(orderNum + " \u8ba2\u5355\u66f4\u65b0\u5931\u8d25\u4e86");
        }
        Integer productType = order.getProductType();
        if (1 == productType) {
            this.saveUserMeetTicket(order);
            UserAction userAction = new UserAction();
            userAction.setUserId(order.getUserId());
            userAction.setType(UserAction.CONSUME);
            userAction.setAmount(amount);
            userAction.setOrderNum(orderNum);
            this.eventPark.post((EventObject)new UserActionEvent(this, userAction));
        } else if (2 == productType) {
            this.updateVipExpireTime(order);
        } else if (3 == productType) {
            UserCert realNameCert = this.userCertService.getOneByUserIdAndType(order.getUserId(), UserCert.TYPE_REAL_NAME);
            JSONObject jsonObject = JSONObject.parseObject((String)order.getExtJson());
            String certType = jsonObject.getString("certType");
            UserCert userCert = new UserCert().setUserId(order.getUserId()).setCertStatus(UserCert.STATUS_CHECKING).setCertType(Integer.parseInt(certType)).setCertContent(realNameCert.getCertContent());
            this.userCertService.cert(userCert);
        } else if (4 == productType && (activityRegistration = this.activityRegistrationService.getOneByOrderNo(order.getOrderNum())) != null) {
            activityRegistration.setStatus(2);
            this.activityRegistrationService.updateById(activityRegistration);
        }
    }

    @Override
    public void refund(Long id) {
        UserOrder order = (UserOrder)this.getById(id);
        if (Objects.isNull(order)) {
            throw new BusinessException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (!order.isWxOrAliPay()) {
            throw new BusinessException("\u53ea\u5141\u8bb8\u652f\u4ed8\u5b9d\u6216\u8005\u5fae\u4fe1\u9000\u6b3e");
        }
        if (!order.permitRefund()) {
            throw new BusinessException("\u5f53\u524d\u652f\u4ed8\u72b6\u6001\u4e0b\u4e0d\u5141\u8bb8\u9000\u6b3e");
        }
        boolean result = this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(UserOrder::getStatus, (Object)5)).eq(UserOrder::getId, (Object)id)).eq(UserOrder::getStatus, (Object)2));
        if (!result) {
            throw new BusinessException("\u8ba2\u5355\u4fee\u6539\u4e2d\uff0c\u8bf7\u91cd\u8bd5");
        }
        PayOrder payOrder = new PayOrder().setOrderNum(order.getOrderNum()).setTradeNum(order.getPaymentId()).setRefundAmount(order.getPaymentAmount()).setRefundNotifyUrl(this.loveLinkGlobalConfig.getRefundNotifyUrl());
        this.payIntegration.refund(payOrder);
    }

    @Override
    public int rechargeOrderCount(Long userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_id", (Object)userId);
        queryWrapper.eq((Object)"status", (Object)2);
        return this.count((Wrapper)queryWrapper);
    }

    private void saveUserMeetTicket(UserOrder order) {
        this.userMeetTicketService.rechargeTicket(new TicketOperateDto().setUserId(order.getUserId()).setAmount(order.getProductAmount()).setConnectId(order.getId()).setType(order.isVipProduct() ? TicketRecordTypeEnum.RECHARGE_VIP : TicketRecordTypeEnum.RECHARGE_NORMAL));
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, timeout=20)
    public void refundCallback(String orderNum, Boolean result) {
        UserOrder order = this.query(orderNum);
        if (Objects.isNull(order)) {
            log.error("\u9000\u6b3e\u56de\u8c03\u8ba2\u5355\u4e0d\u5b58\u5728 orderNum:{}", (Object)orderNum);
            return;
        }
        int status = result != false ? 6 : 7;
        boolean update = this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(UserOrder::getStatus, (Object)status)).eq(UserOrder::getId, (Object)order.getId())).eq(UserOrder::getStatus, (Object)5));
        if (!update) {
            log.error("\u9000\u6b3e\u66f4\u65b0\u5931\u8d25 order:{}", (Object)JSON.toJSONString((Object)order));
        } else {
            UserAction userAction = new UserAction();
            userAction.setUserId(order.getUserId());
            userAction.setType(UserAction.REFUND);
            userAction.setAmount(order.getPaymentAmount());
            userAction.setOrderNum(order.getOrderNum());
            this.eventPark.post((EventObject)new UserActionEvent(this, userAction));
        }
    }

    private void updateVipExpireTime(UserOrder order) {
        JSONObject extObject = JSONObject.parseObject((String)order.getProductExtJson());
        int validDays = extObject.getIntValue("vipValidDays");
        this.userBasicInfoService.updateVipExpireTime(order.getUserId(), validDays);
    }

    @Override
    public boolean existsByTransactionId(String transactionId) {
        return this.count((Wrapper)new QueryWrapper().eq((Object)"payment_id", (Object)transactionId)) > 0;
    }

    @Override
    public UserOrder queryByTransactionId(String transactionId) {
        return (UserOrder)this.getOne((Wrapper)new QueryWrapper().eq((Object)"original_transaction_id", (Object)transactionId));
    }

    @Override
    public UserOrder createIapOrder(Long userId, MeetTicketProduct product, ApplePayIntegration.VerifyReceiptResponse.InApp transaction) {
        String orderNum;
        UserOrder order;
        JSONObject ext = new JSONObject();
        if (Objects.equals(1, product.getProductType()) || Objects.equals(2, product.getProductType())) {
            ext.put("ticketValidDays", (Object)product.getTicketValidDays());
            if (product.getVipValidDays() != null) {
                LocalDateTime vipExpireTime = this.userBasicInfoService.computeVipExpireTime(userId, product.getVipValidDays());
                ext.put("vipExpireTime", (Object)vipExpireTime);
                ext.put("vipValidDays", (Object)product.getVipValidDays());
            }
        }
        if (!this.save(order = new UserOrder().setOrderNum(orderNum = this.idGenerator.next()).setUserId(userId).setMeetTicketProductId(product.getId()).setChannel("AppStore").setProductAmount(product.getAmount()).setProductType(product.getProductType()).setProductName(product.getName()).setProductDesc(product.getDescription()).setTotalPrice(product.getDiscountPrice()).setPaymentAmount(BigDecimal.ZERO).setStatus(1).setPayType(3).setProductExtJson(ext.toJSONString()).setPaymentId(transaction.getTransactionId()))) {
            throw new IllegalStateException("Failed to create IAP order");
        }
        return order;
    }

    @Override
    public List<UserOrder> getPendingIapOrders() {
        return this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"pay_type", (Object)3)).in((Object)"status", new Object[]{0, 1}));
    }
}

