/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.cache.UserBasicInfoTableCache;
import com.bxm.lovelink.common.cache.UserLoveConditionTableCache;
import com.bxm.lovelink.common.cache.UserOtherTableCache;
import com.bxm.lovelink.common.cache.UserTableCache;
import com.bxm.lovelink.common.dal.entity.Region;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.entity.UserAction;
import com.bxm.lovelink.common.dal.entity.UserAudit;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.UserCms;
import com.bxm.lovelink.common.dal.entity.UserComposite;
import com.bxm.lovelink.common.dal.entity.UserLoveCondition;
import com.bxm.lovelink.common.dal.entity.UserOtherInfo;
import com.bxm.lovelink.common.dal.entity.dto.user.UserCompositeDto;
import com.bxm.lovelink.common.dal.entity.vo.user.UserBasicInfoVo;
import com.bxm.lovelink.common.dal.entity.vo.user.UserCompositeVo;
import com.bxm.lovelink.common.dal.entity.vo.user.UserLoveConditionVo;
import com.bxm.lovelink.common.dal.mapper.UserMapper;
import com.bxm.lovelink.common.dal.mapping.UserInfoMapping;
import com.bxm.lovelink.common.dal.mapping.UserTagMapping;
import com.bxm.lovelink.common.dal.service.IRegionService;
import com.bxm.lovelink.common.dal.service.IUserAuditService;
import com.bxm.lovelink.common.dal.service.IUserBasicInfoService;
import com.bxm.lovelink.common.dal.service.IUserCertService;
import com.bxm.lovelink.common.dal.service.IUserCmsService;
import com.bxm.lovelink.common.dal.service.IUserLoveConditionService;
import com.bxm.lovelink.common.dal.service.IUserOnlineService;
import com.bxm.lovelink.common.dal.service.IUserOtherInfoService;
import com.bxm.lovelink.common.dal.service.IUserService;
import com.bxm.lovelink.common.dal.service.IUserTagService;
import com.bxm.lovelink.common.event.promotion.UserActionEvent;
import com.bxm.lovelink.common.event.user.UserCancelEvent;
import com.bxm.lovelink.common.integration.uni.user.UniUserIntegration;
import com.bxm.lovelink.common.integration.uni.user.UniUserRegisterResponse;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.integration.eventbus.EventPark;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.JedisPool;

@Service
public class UserServiceImpl
extends ServiceImpl<UserMapper, User>
implements IUserService {
    private final IUserBasicInfoService userBasicInfoService;
    private final IUserOtherInfoService userOtherInfoService;
    private final IUserLoveConditionService userLoveConditionService;
    private final IUserCertService userCertService;
    private final IUserTagService userTagService;
    private final Fetcher fetcher;
    private final IRegionService regionService;
    private final RedissonClient redissonClient;
    private final IUserAuditService userAuditService;
    private final JedisPool jedisPool;
    private final IUserCmsService userCmsService;
    private final EventPark eventPark;
    private final UniUserIntegration uniUserIntegration;
    private final UserBasicInfoTableCache userBasicInfoCache;
    private final UserOtherTableCache userOtherCache;
    private final UserLoveConditionTableCache userLoveConditionCache;
    private final UserTableCache userTableCache;
    private final IUserOnlineService userOnlineService;

    @Override
    public UserComposite getCompositeById(Long id) {
        User user = (User)this.getById(id);
        if (user == null) {
            return null;
        }
        return new UserComposite().setUser(user).setUserBasicInfo(this.userBasicInfoService.getOneByUserId(id)).setUserLoveCondition(this.userLoveConditionService.getOneByUserId(id)).setUserOtherInfo(this.userOtherInfoService.getOneByUserId(id)).setUserCms(this.userCmsService.getOneByUserId(id)).setUserCerts(this.userCertService.getListNewByUserId(id));
    }

    @Override
    public UserComposite getCompositeByUserNumber(String userNumber) {
        User user = (User)this.getOne((Wrapper)new LambdaQueryWrapper().eq(User::getUserNumber, (Object)userNumber));
        if (user == null) {
            return null;
        }
        return new UserComposite().setUser(user).setUserBasicInfo((UserBasicInfo)this.userBasicInfoCache.getFromAuto(user.getId())).setUserLoveCondition((UserLoveCondition)this.userLoveConditionCache.getFromAuto(user.getId())).setUserOtherInfo((UserOtherInfo)this.userOtherCache.getFromAuto(user.getId()));
    }

    @Override
    public List<UserComposite> getCompositePartByUserIdsFromCache(List<Long> userIds) {
        Map<Long, User> userMap = this.userTableCache.getBatchFromAuto(userIds).stream().collect(Collectors.toMap(User::getId, v -> v));
        Map<Long, UserBasicInfo> basicInfoMap = this.userBasicInfoCache.getBatchFromAuto(userIds).stream().collect(Collectors.toMap(UserBasicInfo::getUserId, v -> v));
        Map<Long, UserLoveCondition> loveConditionMap = this.userLoveConditionCache.getBatchFromAuto(userIds).stream().collect(Collectors.toMap(UserLoveCondition::getUserId, v -> v));
        Map<Long, UserOtherInfo> otherInfoMap = this.userOtherCache.getBatchFromAuto(userIds).stream().collect(Collectors.toMap(UserOtherInfo::getUserId, v -> v));
        ArrayList<UserComposite> composites = new ArrayList<UserComposite>();
        for (Long userId : userIds) {
            User user = userMap.get(userId);
            UserBasicInfo basicInfo = basicInfoMap.get(userId);
            UserLoveCondition loveCondition = loveConditionMap.get(userId);
            UserOtherInfo otherInfo = otherInfoMap.get(userId);
            if (user == null || basicInfo == null || loveCondition == null || otherInfo == null) continue;
            UserComposite composite = new UserComposite().setUser(user).setUserBasicInfo(basicInfo).setUserLoveCondition(loveCondition).setUserOtherInfo(otherInfo);
            composites.add(composite);
        }
        return composites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createUser(User user) {
        String uniqueKey = StringUtils.isNotBlank((CharSequence)user.getUnionid()) ? user.getUnionid() : (StringUtils.isNotBlank((CharSequence)user.getAppleUserId()) ? user.getAppleUserId() : user.getMobile());
        RLock lock = this.redissonClient.getLock(RedisKeys.userCreateLock((String)uniqueKey).generateKey());
        boolean b = lock.tryLock();
        if (!b) {
            throw new IllegalArgumentException("\u6ce8\u518c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)user.getUnionid())) {
                if (this.count((Wrapper)new LambdaQueryWrapper().eq(User::getUnionid, (Object)user.getUnionid())) > 0) {
                    throw new IllegalArgumentException("\u8be5\u5fae\u4fe1\u5df2\u7ecf\u6ce8\u518c\uff0c\u8bf7\u76f4\u63a5\u767b\u5f55");
                }
            } else if (StringUtils.isNotBlank((CharSequence)user.getAppleUserId())) {
                if (this.count((Wrapper)new LambdaQueryWrapper().eq(User::getAppleUserId, (Object)user.getAppleUserId())) > 0) {
                    throw new IllegalArgumentException("\u8be5\u82f9\u679c\u8d26\u53f7\u5df2\u7ecf\u6ce8\u518c\uff0c\u8bf7\u76f4\u63a5\u767b\u5f55");
                }
            } else if (this.count((Wrapper)new LambdaQueryWrapper().eq(User::getMobile, (Object)user.getMobile())) > 0) {
                throw new IllegalArgumentException("\u8be5\u624b\u673a\u53f7\u7801\u5df2\u7ecf\u6ce8\u518c\uff0c\u8bf7\u76f4\u63a5\u767b\u5f55");
            }
            user.setUserNumber(IdUtil.fastSimpleUUID());
            this.save(user);
            this.userBasicInfoService.save(new UserBasicInfo().setUserId(user.getId()));
            this.userOtherInfoService.save(new UserOtherInfo().setUserId(user.getId()));
            this.userLoveConditionService.save(new UserLoveCondition().setUserId(user.getId()));
            this.userCmsService.save(new UserCms().setUserId(user.getId()));
            UniUserRegisterResponse register = this.uniUserIntegration.register(user.getId());
            user.setUniUserId(register.getUid());
            this.updateById(user);
            Long l = user.getId();
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMobile(Long userId, String mobile) {
        RLock lock = this.redissonClient.getLock(RedisKeys.userCreateLock((String)mobile).generateKey());
        boolean b = lock.tryLock();
        if (!b) {
            throw new IllegalArgumentException("\u624b\u673a\u53f7\u7801\u6ce8\u518c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        try {
            if (this.count((Wrapper)new LambdaQueryWrapper().eq(User::getMobile, (Object)mobile)) > 0) {
                throw new IllegalArgumentException("\u624b\u673a\u53f7\u7801\u5df2\u7ecf\u6ce8\u518c\uff0c\u8bf7\u6362\u4e00\u4e2a\u624b\u673a\u53f7");
            }
            this.updateById(new User().setMobile(mobile).setId(userId));
        }
        finally {
            lock.unlock();
        }
        this.eventPark.post((EventObject)new UserActionEvent(this, new UserAction().setUserId(userId).setType(UserAction.ACTIVATION)));
    }

    @Override
    public UserCompositeVo getCompositeVoById(Long id) {
        UserComposite composite = this.getCompositeById(id);
        UserCompositeVo convert = this.convert(composite);
        UserAudit lastOneAudit = this.userAuditService.getLastOneAudit(new UserAudit().setConnectId(composite.getUserBasicInfo().getId()).setUserId(id).setAuditBusiness(UserAudit.AUDIT_BUSINESS_AVATAR));
        if (lastOneAudit != null) {
            convert.setAvatarAuditStatus(lastOneAudit.getAuditStatus());
        }
        return convert;
    }

    @Override
    public UserCompositeVo getCompositeVoByUserNumber(String userNumber) {
        UserComposite composite = this.getCompositeByUserNumber(userNumber);
        return this.convert(composite);
    }

    @Override
    public UserCompositeVo convert(UserComposite composite) {
        if (composite == null) {
            return null;
        }
        Long id = composite.getUser().getId();
        UserCompositeVo vo = UserInfoMapping.INSTANCE.doToVo(composite);
        UserBasicInfoVo basicInfo = vo.getUserBasicInfo();
        UserLoveConditionVo loveCondition = vo.getUserLoveCondition();
        if (CollectionUtils.isNotEmpty(basicInfo.getInterestTag())) {
            basicInfo.setInterestTagVo(UserTagMapping.INSTANCE.doToVo(this.userTagService.listByIds(basicInfo.getInterestTag())));
        }
        ArrayList cityCodes = Lists.newArrayList((Object[])new Integer[]{basicInfo.getCurrentPlaceDistrict(), basicInfo.getNativePlaceDistrict(), basicInfo.getHouseCity(), basicInfo.getLastLoginDistrict()});
        if (CollectionUtils.isNotEmpty(loveCondition.getNativePlaceRange())) {
            cityCodes.addAll(loveCondition.getNativePlaceRange());
        }
        Map<Integer, String> codeMap = this.regionService.queryByCodes(cityCodes);
        this.fillRegionName(vo, codeMap);
        vo.setActive(this.userOnlineService.getOnline(id));
        return vo;
    }

    @Override
    public List<UserCompositeVo> convert(List<UserComposite> composite) {
        List<UserCompositeVo> vos = UserInfoMapping.INSTANCE.doToVo(composite);
        if (CollectionUtils.isEmpty(composite)) {
            return vos;
        }
        ArrayList tagIds = Lists.newArrayList();
        ArrayList userIds = Lists.newArrayList();
        vos.forEach(c -> {
            userIds.add(c.getUser().getId());
            UserBasicInfoVo basicInfo = c.getUserBasicInfo();
            if (CollectionUtils.isNotEmpty(basicInfo.getInterestTag())) {
                tagIds.addAll(basicInfo.getInterestTag());
            }
        });
        Map<Object, Object> tagMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)tagIds)) {
            tagMap = this.userTagService.fetchAll(UserTagMapping.INSTANCE::doToVo);
        }
        Map<Integer, String> codeMap = this.regionService.fetchAll(Region::getName);
        Map<Long, Boolean> onlineMap = this.userOnlineService.getBatchOnline(userIds);
        Map<Object, Object> finalTagMap = tagMap;
        vos.forEach(c -> {
            UserBasicInfoVo basicInfo = c.getUserBasicInfo();
            this.fillRegionName((UserCompositeVo)c, codeMap);
            if (CollectionUtils.isNotEmpty(basicInfo.getInterestTag())) {
                basicInfo.setInterestTagVo(basicInfo.getInterestTag().stream().map(finalTagMap::get).collect(Collectors.toList()));
            }
            c.setActive((Boolean)onlineMap.get(basicInfo.getUserId()));
        });
        return vos;
    }

    private void fillRegionName(UserCompositeVo vo, Map<Integer, String> codeMap) {
        if (vo == null || codeMap == null || codeMap.size() == 0) {
            return;
        }
        UserBasicInfoVo basicInfo = vo.getUserBasicInfo();
        UserLoveConditionVo loveCondition = vo.getUserLoveCondition();
        basicInfo.setCurrentPlaceProvinceName(codeMap.get(basicInfo.getCurrentPlaceProvince()));
        basicInfo.setCurrentPlaceCityName(codeMap.get(basicInfo.getCurrentPlaceCity()));
        basicInfo.setCurrentPlaceDistrictName(codeMap.get(basicInfo.getCurrentPlaceDistrict()));
        basicInfo.setNativePlaceProvinceName(codeMap.get(basicInfo.getNativePlaceProvince()));
        basicInfo.setNativePlaceCityName(codeMap.get(basicInfo.getNativePlaceCity()));
        basicInfo.setNativePlaceDistrictName(codeMap.get(basicInfo.getNativePlaceDistrict()));
        basicInfo.setHouseCityName(codeMap.get(basicInfo.getHouseCity()));
        basicInfo.setHouseProvinceName(codeMap.get(basicInfo.getHouseProvince()));
        basicInfo.setLastLoginDistrictName(codeMap.get(basicInfo.getLastLoginDistrict()));
        if (CollectionUtils.isNotEmpty(loveCondition.getNativePlaceRange())) {
            loveCondition.setNativePlaceNameRange(loveCondition.getNativePlaceRange().stream().map(codeMap::get).collect(Collectors.toList()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateByCompositeDto(UserCompositeDto dto, UserComposite composite) {
        this.userBasicInfoService.updateByDto(dto.getUserBasicInfo(), composite);
        this.userLoveConditionService.updateByDto(dto.getUserLoveCondition(), composite);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancel(UserComposite userComposite, String reason) {
        Long userId = userComposite.getUser().getId();
        this.updateById(new User().setId(userId).setCancelReason(reason));
        this.removeById(userId);
        this.userBasicInfoService.removeById(userComposite.getUserBasicInfo().getId());
        this.userLoveConditionService.removeById(userComposite.getUserBasicInfo().getId());
        this.userCmsService.removeById(userComposite.getUserCms().getId());
        this.userOtherInfoService.removeById(userComposite.getUserOtherInfo().getId());
        this.eventPark.post((EventObject)new UserCancelEvent(this, userId, userComposite));
    }

    public UserServiceImpl(IUserBasicInfoService userBasicInfoService, IUserOtherInfoService userOtherInfoService, IUserLoveConditionService userLoveConditionService, IUserCertService userCertService, IUserTagService userTagService, Fetcher fetcher, IRegionService regionService, RedissonClient redissonClient, IUserAuditService userAuditService, JedisPool jedisPool, IUserCmsService userCmsService, EventPark eventPark, UniUserIntegration uniUserIntegration, UserBasicInfoTableCache userBasicInfoCache, UserOtherTableCache userOtherCache, UserLoveConditionTableCache userLoveConditionCache, UserTableCache userTableCache, IUserOnlineService userOnlineService) {
        this.userBasicInfoService = userBasicInfoService;
        this.userOtherInfoService = userOtherInfoService;
        this.userLoveConditionService = userLoveConditionService;
        this.userCertService = userCertService;
        this.userTagService = userTagService;
        this.fetcher = fetcher;
        this.regionService = regionService;
        this.redissonClient = redissonClient;
        this.userAuditService = userAuditService;
        this.jedisPool = jedisPool;
        this.userCmsService = userCmsService;
        this.eventPark = eventPark;
        this.uniUserIntegration = uniUserIntegration;
        this.userBasicInfoCache = userBasicInfoCache;
        this.userOtherCache = userOtherCache;
        this.userLoveConditionCache = userLoveConditionCache;
        this.userTableCache = userTableCache;
        this.userOnlineService = userOnlineService;
    }
}

