/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.bxm.lovelink.common.dal.entity.dao.MeetGroupCountDao;
import com.bxm.lovelink.common.dal.entity.dao.heartbeat.HeartBeatCountDao;
import com.bxm.lovelink.common.dal.entity.dao.visit.UserVisitCountDao;
import com.bxm.lovelink.common.dal.entity.vo.userstatistics.UserStatisticsVo;
import com.bxm.lovelink.common.dal.mapper.MeetGroupMapper;
import com.bxm.lovelink.common.dal.mapper.UserRelationMapper;
import com.bxm.lovelink.common.dal.mapper.UserVisitRecordMapper;
import com.bxm.lovelink.common.dal.service.UserStatisticsService;
import org.springframework.stereotype.Service;

@Service
public class UserStatisticsServiceImpl
implements UserStatisticsService {
    private final UserRelationMapper userRelationMapper;
    private final MeetGroupMapper meetGroupMapper;
    private final UserVisitRecordMapper userVisitRecordMapper;

    public UserStatisticsServiceImpl(UserRelationMapper userRelationMapper, MeetGroupMapper meetGroupMapper, UserVisitRecordMapper userVisitRecordMapper) {
        this.userRelationMapper = userRelationMapper;
        this.meetGroupMapper = meetGroupMapper;
        this.userVisitRecordMapper = userVisitRecordMapper;
    }

    @Override
    public UserStatisticsVo queryUserStatisticsInfo(Long userId) {
        HeartBeatCountDao heartBeatCountDao = this.userRelationMapper.selectHeartBeatCounts(userId);
        MeetGroupCountDao meetGroupCountDao = this.meetGroupMapper.selectMeetGroupCount(userId);
        UserVisitCountDao userVisitCountDao = this.userVisitRecordMapper.selectUserVisitCount(userId);
        return new UserStatisticsVo().setHeartBeatCount(heartBeatCountDao.getHeartBeatCount()).setHeartBeatMeCount(heartBeatCountDao.getHeartBeatMeCount()).setReserveCount(meetGroupCountDao.getReserveCount()).setDatingCount(meetGroupCountDao.getDatingCount()).setVisitorCount(userVisitCountDao.getVisitorCount()).setHighFrequencyVisitorCount(userVisitCountDao.getHighFrequencyVisitorCount()).setUnMatchedHeartBeatCount(heartBeatCountDao.getUnMatchedHeartBeatCount());
    }
}

