/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.dal.entity.UserTag;
import com.bxm.lovelink.common.dal.entity.vo.user.UserTagVo;
import com.bxm.lovelink.common.dal.mapper.UserTagMapper;
import com.bxm.lovelink.common.dal.mapping.UserTagMapping;
import com.bxm.lovelink.common.dal.service.IUserTagService;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.Target;
import com.bxm.warcar.xcache.TargetFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class UserTagServiceImpl
extends ServiceImpl<UserTagMapper, UserTag>
implements IUserTagService {
    private final Fetcher fetcher;

    public UserTagServiceImpl(Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public List<UserTagVo> listByRootChildren(Integer type) {
        return this.listByRoot(type).getChildren();
    }

    @Override
    public UserTagVo listByRoot(Integer type) {
        Map<Long, List<UserTag>> tagMap = this.list((Wrapper)new LambdaQueryWrapper().eq(Objects.nonNull(type), UserTag::getType, (Object)type)).stream().collect(Collectors.groupingBy(UserTag::getParentId, Collectors.toList()));
        UserTagVo root = new UserTagVo().setId(0L);
        this.buildTree(root, tagMap);
        return root;
    }

    private void buildTree(UserTagVo result, Map<Long, List<UserTag>> tagMap) {
        List<UserTag> tags = tagMap.get(result.getId());
        if (CollectionUtils.isEmpty(tags)) {
            return;
        }
        List<UserTagVo> voList = UserTagMapping.INSTANCE.doToVo(tags);
        result.setChildren(voList);
        for (UserTagVo vo : voList) {
            this.buildTree(vo, tagMap);
        }
    }

    @Override
    public <U> Map<Long, U> fetchAll(Function<UserTag, U> valueMapper) {
        Target target = new TargetFactory().keyGenerator(() -> KeyBuilder.build((Object[])new Object[]{"lovelink", "userTag", "all"})).cls(UserTag.class).expireTimeInSecond(1800).listDataExtractor(() -> ((UserTagServiceImpl)this).list()).build();
        List userTags = this.fetcher.fetchToList(target);
        if (CollectionUtils.isEmpty((Collection)userTags)) {
            return Collections.emptyMap();
        }
        return userTags.stream().collect(Collectors.toMap(UserTag::getId, valueMapper));
    }
}

