/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.dal.entity.UserVisitRecord;
import com.bxm.lovelink.common.dal.entity.dao.visit.UserVisitorListDao;
import com.bxm.lovelink.common.dal.entity.dto.heartbeat.UserClearUnReadDto;
import com.bxm.lovelink.common.dal.entity.dto.visit.VisitorQueryDto;
import com.bxm.lovelink.common.dal.entity.vo.visit.UserVisitorListVo;
import com.bxm.lovelink.common.dal.mapper.UserVisitRecordMapper;
import com.bxm.lovelink.common.dal.mapping.UserVisitMapping;
import com.bxm.lovelink.common.dal.service.IUserVisitRecordService;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserVisitRecordServiceImpl
extends ServiceImpl<UserVisitRecordMapper, UserVisitRecord>
implements IUserVisitRecordService {
    @Override
    public IPage<UserVisitorListVo> visitorList(VisitorQueryDto dto) {
        dto.validateLocationIfRequired();
        int total = ((UserVisitRecordMapper)this.baseMapper).countVisitorList(dto);
        if (total == 0) {
            return new Page((long)dto.getCurrent(), (long)dto.getSize());
        }
        int offset = (dto.getCurrent() - 1) * dto.getSize();
        List<UserVisitorListDao> visitorListDaoList = ((UserVisitRecordMapper)this.baseMapper).visitorList(dto, offset, dto.getSize());
        Page visitorListDaoPage = new Page((long)dto.getCurrent(), (long)dto.getSize(), (long)total);
        visitorListDaoPage.setRecords(visitorListDaoList);
        Page<UserVisitorListVo> page = UserVisitMapping.INSTANCE.toPage((IPage<UserVisitorListDao>)visitorListDaoPage);
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return page;
        }
        this.buildVisitTitle(page.getRecords());
        return page;
    }

    private void buildVisitTitle(List<UserVisitorListVo> records) {
        for (UserVisitorListVo record : records) {
            String title;
            Duration duration = Duration.between(record.getLastVisitTime(), LocalDateTime.now());
            long hours = duration.toHours();
            long days = duration.toDays();
            if (record.getVisitCount() > 1) {
                title = record.getGenderName() + "\u8fd1\u671f\u53cd\u590d\u770b\u8fc7\u4f60" + record.getVisitCount() + "\u6b21";
            } else {
                String timeDesc;
                if (days > 30L) {
                    long months = days / 30L;
                    timeDesc = months + "\u4e2a\u6708\u524d";
                } else {
                    timeDesc = days >= 1L ? days + "\u5929\u524d" : (hours >= 1L ? hours + "\u5c0f\u65f6\u524d" : "\u521a\u521a");
                }
                title = record.getGenderName() + timeDesc + "\u8bbf\u95ee\u8fc7\u4f60";
            }
            record.setTitle(title);
        }
    }

    @Override
    public void clearUnread(Long userId, UserClearUnReadDto dto) {
        LambdaUpdateWrapper lambdaUpdate = new LambdaUpdateWrapper();
        lambdaUpdate.eq(UserVisitRecord::getUserId, (Object)userId);
        lambdaUpdate.in(UserVisitRecord::getTargetUserId, dto.getTargetUserIds());
        lambdaUpdate.eq(UserVisitRecord::getReadStatus, (Object)0);
        lambdaUpdate.set(UserVisitRecord::getReadStatus, (Object)1);
        this.update((Wrapper)lambdaUpdate);
    }
}

