/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.service.impl.huawei;

import com.bxm.lovelink.common.autoconfigure.HuaweiProperties;
import com.bxm.lovelink.common.dal.entity.dto.meet.VirtualPhoneNumberBindResult;
import com.bxm.lovelink.common.dal.service.impl.AbstractVirtualPhoneNumberService;
import com.bxm.lovelink.common.dal.service.impl.huawei.AXBBindRequest;
import com.bxm.lovelink.common.dal.service.impl.huawei.AXBBindResponse;
import com.bxm.lovelink.common.dal.service.impl.huawei.AXBUnbindResponse;
import com.bxm.lovelink.common.dal.service.impl.huawei.impl.StringUtil;
import com.bxm.lovelink.common.exception.BusinessException;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.integration.pair.Value;
import com.bxm.warcar.utils.JsonHelper;
import java.util.List;
import java.util.Random;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HuaweiVirtualPhoneNumberServiceImpl
extends AbstractVirtualPhoneNumberService {
    private static final Logger log = LoggerFactory.getLogger(HuaweiVirtualPhoneNumberServiceImpl.class);
    private final HttpClient httpClient;
    private final String appKey;
    private final String appSecret;
    private final Pair pair;

    public HuaweiVirtualPhoneNumberServiceImpl(HttpClient httpClient, HuaweiProperties huaweiProperties, Pair pair, Fetcher fetcher, Updater updater) {
        super(fetcher, updater);
        this.httpClient = httpClient;
        this.appKey = huaweiProperties.getOmpAppKey();
        this.appSecret = huaweiProperties.getOmpAppSecret();
        this.pair = pair;
    }

    @Override
    public VirtualPhoneNumberBindResult bind(String a, String b) {
        HttpPost post = new HttpPost("https://rtcpns.cn-north-1.myhuaweicloud.com/rest/caas/relationnumber/partners/v1.0");
        try {
            AXBBindRequest request = new AXBBindRequest();
            request.setCallerNum(this.appendCountryCodeIfNeeded(a));
            request.setCalleeNum(this.appendCountryCodeIfNeeded(b));
            request.setRelationNum(this.appendCountryCodeIfNeeded(this.randomRelationNumber()));
            request.setDuration(this.getExpireTimeInSecond());
            post.addHeader("Content-Type", "application/json");
            post.addHeader("Authorization", "AKSK realm=\"SDP\",profile=\"UsernameToken\",type=\"Appkey\"");
            post.addHeader("X-AKSK", StringUtil.buildAKSKHeader(this.appKey, this.appSecret));
            post.setEntity((HttpEntity)new StringEntity(JsonHelper.convert((Object)request)));
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)post);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.error("\u9690\u79c1\u53f7\u7801\u4fdd\u62a4\u7ed1\u5b9a\u5931\u8d25\uff01{}", (Object)statusCode);
                throw new BusinessException("\u9690\u79c1\u53f7\u7801\u4fdd\u62a4\u7ed1\u5b9a\u5931\u8d25\uff01");
            }
            String body = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            AXBBindResponse response = (AXBBindResponse)JsonHelper.convert((String)body, AXBBindResponse.class);
            if (!response.isSuccess()) {
                log.error("\u9690\u79c1\u53f7\u7801\u4fdd\u62a4\u7ed1\u5b9a\u5931\u8d25\uff01{}", (Object)body);
                throw new BusinessException("\u9690\u79c1\u53f7\u7801\u4fdd\u62a4\u7ed1\u5b9a\u5931\u8d25\uff01");
            }
            VirtualPhoneNumberBindResult virtualPhoneNumberBindResult = new VirtualPhoneNumberBindResult().setVirtualNumber(response.getRelationNum()).setSubscriptionId(response.getSubscriptionId());
            return virtualPhoneNumberBindResult;
        }
        catch (Exception e) {
            log.error("\u9690\u79c1\u53f7\u7801\u4fdd\u62a4\u7ed1\u5b9a\u5f02\u5e38:", (Throwable)e);
            if (e instanceof BusinessException) {
                throw (BusinessException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            post.releaseConnection();
        }
    }

    @Override
    public void unbind(String subscriptionId) {
        String url = String.format("https://rtcpns.cn-north-1.myhuaweicloud.com/rest/caas/relationnumber/partners/v1.0?subscriptionId=%s", subscriptionId);
        HttpDelete delete = new HttpDelete(url);
        try {
            delete.addHeader("Content-Type", "application/json");
            delete.addHeader("Authorization", "AKSK realm=\"SDP\",profile=\"UsernameToken\",type=\"Appkey\"");
            delete.addHeader("X-AKSK", StringUtil.buildAKSKHeader(this.appKey, this.appSecret));
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)delete);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.error("\u9690\u79c1\u53f7\u7801\u4fdd\u62a4\u89e3\u7ed1\u5931\u8d25\uff01{}", (Object)statusCode);
                throw new BusinessException("\u9690\u79c1\u53f7\u7801\u4fdd\u62a4\u89e3\u7ed1\u5931\u8d25\uff01");
            }
            String body = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            AXBUnbindResponse response = (AXBUnbindResponse)JsonHelper.convert((String)body, AXBUnbindResponse.class);
            if (!response.isSuccess()) {
                log.error("\u9690\u79c1\u53f7\u7801\u4fdd\u62a4\u89e3\u7ed1\u5931\u8d25\uff01{}", (Object)body);
                throw new BusinessException("\u9690\u79c1\u53f7\u7801\u4fdd\u62a4\u89e3\u7ed1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            log.error("\u9690\u79c1\u53f7\u7801\u4fdd\u62a4\u89e3\u7ed1\u5f02\u5e38:", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            delete.releaseConnection();
        }
    }

    private String appendCountryCodeIfNeeded(String number) {
        return number.startsWith("+") || number.startsWith("0") ? number : "+86" + number;
    }

    private String randomRelationNumber() {
        Value value = this.pair.get("huawei_omp_relation_numbers");
        List list = value.ofArrayList();
        if (list == null || list.isEmpty()) {
            log.warn("\u83b7\u53d6\u5173\u7cfb\u53f7\u7801\u5931\u8d25\uff0c\u8bf7\u914d\u7f6e\uff1a{}", (Object)"huawei_omp_relation_numbers");
            throw new BusinessException("\u83b7\u53d6\u5173\u7cfb\u53f7\u7801\u5931\u8d25");
        }
        return (String)list.get(new Random().nextInt(list.size()));
    }
}

