/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.strategy;

import com.bxm.lovelink.common.dal.entity.InsertCard;
import com.bxm.lovelink.common.dal.entity.InsertCardContext;
import com.bxm.lovelink.common.dal.strategy.AbstractRewardInsertCardStrategy;
import com.bxm.lovelink.common.dal.strategy.InsertCardConfig;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.utils.JsonHelper;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class GuideCardInsertCardStrategy
extends AbstractRewardInsertCardStrategy {
    private final Pair pair;
    private final Fetcher fetcher;
    private final Updater updater;

    public GuideCardInsertCardStrategy(Pair pair, Fetcher fetcher, Updater updater) {
        this.pair = pair;
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public Integer getCardType() {
        return 1;
    }

    @Override
    public List<InsertCard> computeInsertCards(InsertCardContext context) {
        ArrayList<InsertCard> result = new ArrayList<InsertCard>();
        List<Integer> pool = this.getAvailableCardPool(context);
        if (pool.isEmpty()) {
            return result;
        }
        Integer selectedCard = pool.get(new Random().nextInt(pool.size()));
        int positionRemainder = this.getPositionRemainder();
        int todaySwipeCount = context.getTodaySwipeCount() + (Integer)ObjectUtils.defaultIfNull((Object)context.getWaitSwipeCount(), (Object)0);
        Integer requestSize = context.getRequestSize();
        int start = todaySwipeCount + 1;
        int end = todaySwipeCount + requestSize;
        for (int point = start; point <= end; ++point) {
            if (point % 10 != positionRemainder) continue;
            int insertIndex = point - todaySwipeCount - 1;
            result.add(new InsertCard(insertIndex, this.getCardType(), selectedCard, 0));
        }
        return result;
    }

    private List<Integer> getAvailableCardPool(InsertCardContext context) {
        String date = LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE);
        ArrayList<Integer> pool = new ArrayList<Integer>();
        if (!context.getUserInfoComplete().booleanValue()) {
            pool.add(1);
        }
        Set cards = this.fetcher.sfetchAll(RedisKeys.userTodayExposeGuideCard((Long)context.getUserId(), (String)date), Integer.class);
        pool.removeIf(cards::contains);
        return pool;
    }

    private int getPositionRemainder() {
        int positionRemainder = 8;
        String insertCardConfigStr = this.pair.get("insert_card_config").of();
        if (StringUtils.isBlank((CharSequence)insertCardConfigStr)) {
            return positionRemainder;
        }
        InsertCardConfig insertCardConfig = (InsertCardConfig)JsonHelper.convert((String)insertCardConfigStr, InsertCardConfig.class);
        if (Objects.isNull(insertCardConfig) || MapUtils.isEmpty(insertCardConfig.getCardConfigMap())) {
            return positionRemainder;
        }
        Map<Integer, InsertCardConfig.CardConfig> cardConfigMap = insertCardConfig.getCardConfigMap();
        InsertCardConfig.CardConfig cardConfig = cardConfigMap.get(this.getCardType());
        if (Objects.nonNull(cardConfig) && Objects.nonNull(cardConfig.getPositionRemainder())) {
            return cardConfig.getPositionRemainder();
        }
        return positionRemainder;
    }

    @Override
    public Integer getSort() {
        return 3;
    }
}

