/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.strategy;

import com.bxm.lovelink.common.dal.entity.InsertCard;
import com.bxm.lovelink.common.dal.entity.InsertCardContext;
import com.bxm.lovelink.common.dal.strategy.InsertCardStrategy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class InsertCardStrategyFactory
implements ApplicationListener<ApplicationReadyEvent> {
    private final Map<Integer, InsertCardStrategy> strategyMap = new ConcurrentHashMap<Integer, InsertCardStrategy>();

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        applicationContext.getBeansOfType(InsertCardStrategy.class).values().forEach(strategy -> this.strategyMap.put(strategy.getCardType(), (InsertCardStrategy)strategy));
    }

    public InsertCardStrategy getStrategy(int type) {
        return this.strategyMap.get(type);
    }

    public List<InsertCard> computeAllInsertCards(InsertCardContext context) {
        ArrayList<InsertCard> result = new ArrayList<InsertCard>();
        HashSet<Integer> insertedIndexSet = new HashSet<Integer>();
        ArrayList<InsertCardStrategy> strategies = new ArrayList<InsertCardStrategy>(this.strategyMap.values());
        strategies.sort(Comparator.comparingInt(InsertCardStrategy::getSort));
        for (InsertCardStrategy strategy : strategies) {
            for (InsertCard card : strategy.computeInsertCards(context)) {
                if (!insertedIndexSet.add(card.getIndex())) continue;
                result.add(card);
            }
        }
        result.sort(Comparator.comparingInt(InsertCard::getIndex).reversed());
        return result;
    }
}

