/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.strategy;

import com.bxm.lovelink.common.dal.entity.InsertCard;
import com.bxm.lovelink.common.dal.entity.InsertCardContext;
import com.bxm.lovelink.common.dal.entity.InviteConfig;
import com.bxm.lovelink.common.dal.strategy.AbstractRewardInsertCardStrategy;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Component;

@Component
public class InviteInsertCardStrategy
extends AbstractRewardInsertCardStrategy {
    private final Counter counter;

    @Override
    public Integer getCardType() {
        return 2;
    }

    @Override
    public List<InsertCard> computeInsertCards(InsertCardContext context) {
        ArrayList<InsertCard> result = new ArrayList<InsertCard>();
        String date = LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE);
        KeyGenerator inviteUserRewardCountKey = RedisKeys.inviteUserRewardCount((Long)context.getUserId());
        Long inviteBrowseCount = (Long)ObjectUtils.defaultIfNull((Object)this.counter.hget(inviteUserRewardCountKey, date), (Object)0L);
        InviteConfig inviteConfig = this.getInviteConfig();
        int totalLimit = inviteConfig.getBasicBrowseCount() + inviteBrowseCount.intValue();
        int todaySwipeCount = context.getTodaySwipeCount() + (Integer)ObjectUtils.defaultIfNull((Object)context.getWaitSwipeCount(), (Object)0);
        int requestSize = context.getRequestSize();
        int startSwipe = todaySwipeCount + 1;
        int endSwipe = todaySwipeCount + requestSize;
        int cardTriggerSwipe = totalLimit + 1;
        if (cardTriggerSwipe >= startSwipe && cardTriggerSwipe <= endSwipe) {
            int insertIndex = cardTriggerSwipe - todaySwipeCount - 1;
            result.add(new InsertCard(insertIndex, this.getCardType(), 2, 2));
        } else if (cardTriggerSwipe < startSwipe) {
            result.add(new InsertCard(0, this.getCardType(), 2, 2));
        }
        HashSet set = new HashSet();
        return result.stream().filter(card -> set.add(card.getIndex())).collect(Collectors.toList());
    }

    public static void main(String[] args) {
        ArrayList<InsertCard> result = new ArrayList<InsertCard>();
        int requestSize = 5;
        int todaySwipeCount = 30;
        int totalLimit = 30;
        int startSwipe = todaySwipeCount + 1;
        int endSwipe = todaySwipeCount + requestSize;
        int cardTriggerSwipe = totalLimit + 1;
        if (cardTriggerSwipe >= startSwipe && cardTriggerSwipe <= endSwipe) {
            int insertIndex = cardTriggerSwipe - todaySwipeCount - 1;
            result.add(new InsertCard(insertIndex, 1, 2, 0));
        } else if (cardTriggerSwipe < startSwipe) {
            result.add(new InsertCard(0, 1, 2, 0));
        }
        System.out.println(result);
    }

    @Override
    public Integer getSort() {
        return 1;
    }

    public InviteInsertCardStrategy(Counter counter) {
        this.counter = counter;
    }
}

