/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.strategy;

import com.bxm.lovelink.common.dal.entity.InsertCard;
import com.bxm.lovelink.common.dal.entity.InsertCardContext;
import com.bxm.lovelink.common.dal.entity.InviteConfig;
import com.bxm.lovelink.common.dal.strategy.AbstractRewardInsertCardStrategy;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Component;

@Component
public class RealNameInsertCardStrategy
extends AbstractRewardInsertCardStrategy {
    @Override
    public Integer getCardType() {
        return 3;
    }

    @Override
    public List<InsertCard> computeInsertCards(InsertCardContext context) {
        ArrayList<InsertCard> result = new ArrayList<InsertCard>();
        if (context.getRealName().booleanValue()) {
            return result;
        }
        InviteConfig inviteConfig = this.getInviteConfig();
        int totalLimit = inviteConfig.getNoCertBrowseCount();
        int todaySwipeCount = context.getTodaySwipeCount() + (Integer)ObjectUtils.defaultIfNull((Object)context.getWaitSwipeCount(), (Object)0);
        int startSwipe = todaySwipeCount + 1;
        int endSwipe = todaySwipeCount + context.getRequestSize();
        int cardTriggerSwipe = totalLimit + 1;
        if (cardTriggerSwipe >= startSwipe && cardTriggerSwipe <= endSwipe) {
            int insertIndex = cardTriggerSwipe - todaySwipeCount - 1;
            result.add(new InsertCard(insertIndex, this.getCardType(), 3, 1));
        }
        return result;
    }

    @Override
    public Integer getSort() {
        return 2;
    }
}

