/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.user.audit;

import com.bxm.lovelink.common.dal.entity.UserAudit;
import com.bxm.lovelink.common.dal.user.audit.UserAuditHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class UserAuditHandlerManager
implements ApplicationListener<ApplicationReadyEvent> {
    private final Map<Integer, UserAuditHandler> handlerMap = new ConcurrentHashMap<Integer, UserAuditHandler>();

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map beansOfType = applicationContext.getBeansOfType(UserAuditHandler.class);
        beansOfType.forEach((name, handler) -> this.handlerMap.put(handler.auditType(), (UserAuditHandler)handler));
    }

    public Integer auditHandle(UserAudit userAudit) {
        UserAuditHandler handler = this.handlerMap.get(userAudit.getAuditType());
        if (handler == null) {
            throw new IllegalArgumentException("No handler found for audit type: " + userAudit.getAuditType());
        }
        return handler.auditHandle(userAudit);
    }
}

