/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.user.basicinfo;

import com.bxm.lovelink.common.dal.entity.UserAlbum;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.service.ISensitiveService;
import com.bxm.lovelink.common.dal.user.basicinfo.BuilderSortEnum;
import com.bxm.lovelink.common.dal.user.basicinfo.UserBasicInfoBuilder;
import com.bxm.lovelink.common.dal.user.basicinfo.UserBasicInfoBuilderContext;
import com.bxm.lovelink.common.exception.BusinessException;
import com.bxm.lovelink.common.integration.sensitive.SensitiveImageResult;
import com.bxm.lovelink.common.integration.sensitive.SensitiveImageType;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class UserBasicInfoAlbumBuilder
implements UserBasicInfoBuilder {
    private final ISensitiveService sensitiveService;
    private final ThreadPoolExecutor executor;

    public UserBasicInfoAlbumBuilder(ISensitiveService sensitiveService) {
        this.sensitiveService = sensitiveService;
        this.executor = new ThreadPoolExecutor(20, 200, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("user_album_audit"));
    }

    @Override
    public void buildAndCheck(UserBasicInfoBuilderContext context, UserBasicInfo userBasicInfo) {
        List<UserAlbum> newAlbum = userBasicInfo.getAlbum();
        if (CollectionUtils.isEmpty(newAlbum)) {
            return;
        }
        UserBasicInfo existBasicInfo = context.getExistBasicInfo();
        List<UserAlbum> existAlbum = existBasicInfo.getAlbum();
        if (existAlbum == null) {
            existAlbum = new ArrayList<UserAlbum>();
        }
        List md5s = existAlbum.stream().map(UserAlbum::getMd5).collect(Collectors.toList());
        ArrayList<String> needCheck = new ArrayList<String>();
        for (UserAlbum album : newAlbum) {
            if (md5s.contains(album.getMd5())) continue;
            needCheck.add(album.getUrl());
        }
        if (CollectionUtils.isEmpty(needCheck)) {
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(needCheck.size());
        ArrayList<Future<SensitiveImageResult>> futures = new ArrayList<Future<SensitiveImageResult>>();
        for (String string : needCheck) {
            futures.add(this.executor.submit(() -> {
                try {
                    SensitiveImageResult sensitiveImageResult = this.sensitiveService.checkImage(SensitiveImageType.LIFE, url);
                    return sensitiveImageResult;
                }
                finally {
                    countDownLatch.countDown();
                }
            }));
        }
        try {
            countDownLatch.await();
            for (Future future : futures) {
                SensitiveImageResult result = (SensitiveImageResult)future.get();
                if (!result.getHit().booleanValue()) continue;
                throw new IllegalArgumentException("\u7167\u7247\u5185\u5bb9\u4e0d\u5408\u89c4\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            }
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u7167\u7247\u68c0\u6d4b\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5");
        }
    }

    public int getOrder() {
        return BuilderSortEnum.ALBUM_AUDIT.getCode();
    }
}

