/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.user.basicinfo;

import com.bxm.lovelink.common.dal.entity.UserAudit;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.service.IUserAuditService;
import com.bxm.lovelink.common.dal.user.basicinfo.BuilderSortEnum;
import com.bxm.lovelink.common.dal.user.basicinfo.UserBasicInfoBuilder;
import com.bxm.lovelink.common.dal.user.basicinfo.UserBasicInfoBuilderContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class UserBasicInfoAvatarAuditBuilder
implements UserBasicInfoBuilder {
    private final IUserAuditService userAuditService;

    public UserBasicInfoAvatarAuditBuilder(IUserAuditService userAuditService) {
        this.userAuditService = userAuditService;
    }

    @Override
    public void buildAndCheck(UserBasicInfoBuilderContext context, UserBasicInfo userBasicInfo) {
        String image = userBasicInfo.getOriginalImage();
        if (StringUtils.isBlank((CharSequence)image)) {
            return;
        }
        UserAudit lastOneAudit = this.userAuditService.getLastOneAudit(new UserAudit().setConnectId(userBasicInfo.getId()).setUserId(userBasicInfo.getUserId()).setAuditBusiness(UserAudit.AUDIT_BUSINESS_AVATAR));
        if (lastOneAudit != null && lastOneAudit.isWait()) {
            throw new IllegalArgumentException("\u5b58\u5728\u672a\u5ba1\u6838\u7ed3\u675f\u7684\u5934\u50cf\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6838\u901a\u8fc7\u540e\u518d\u8fdb\u884c\u5934\u50cf\u4e0a\u4f20\uff01");
        }
        UserAudit userAudit = new UserAudit().setAuditType(UserAudit.TYPE_IMAGE).setAuditAuto(UserAudit.AUDIT_AUTO).setAuditBusiness(UserAudit.AUDIT_BUSINESS_AVATAR).setAuditContent(image).setUserId(userBasicInfo.getUserId()).setConnectId(userBasicInfo.getId());
        this.userAuditService.createAudit(userAudit);
    }

    public int getOrder() {
        return BuilderSortEnum.AVATAR_AUDIT.getCode();
    }
}

