/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.user.basicinfo;

import com.bxm.lovelink.common.contant.UserConstants;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.user.basicinfo.BuilderSortEnum;
import com.bxm.lovelink.common.dal.user.basicinfo.UserBasicInfoBuilder;
import com.bxm.lovelink.common.dal.user.basicinfo.UserBasicInfoBuilderContext;
import java.time.LocalDate;
import org.springframework.stereotype.Component;

@Component
public class UserBasicInfoBirthdayBuilder
implements UserBasicInfoBuilder {
    @Override
    public void buildAndCheck(UserBasicInfoBuilderContext context, UserBasicInfo userBasicInfo) {
        LocalDate birthday = userBasicInfo.getBirthday();
        if (birthday == null) {
            return;
        }
        userBasicInfo.setZodiac(UserConstants.UserZodiacEnum.getByBirthday(birthday).getCode());
        UserConstants.UserConstellationEnum x = UserConstants.UserConstellationEnum.getByBirthday(birthday);
        if (x != null) {
            userBasicInfo.setConstellation(x.getCode());
        }
    }

    public int getOrder() {
        return BuilderSortEnum.BIRTHDAY.getCode();
    }
}

