/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.user.basicinfo;

import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.user.basicinfo.UserBasicInfoBuilder;
import com.bxm.lovelink.common.dal.user.basicinfo.UserBasicInfoBuilderContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class UserBasicInfoBuilderChain
implements ApplicationListener<ApplicationReadyEvent> {
    private final List<UserBasicInfoBuilder> builderList = new ArrayList<UserBasicInfoBuilder>();

    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        this.builderList.addAll(applicationContext.getBeansOfType(UserBasicInfoBuilder.class).values().stream().sorted(Comparator.comparingInt(Ordered::getOrder)).collect(Collectors.toList()));
    }

    public void buildAndCheck(UserBasicInfoBuilderContext context, UserBasicInfo userBasicInfo) {
        for (UserBasicInfoBuilder builder : this.builderList) {
            builder.buildAndCheck(context, userBasicInfo);
        }
    }
}

