/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.user.basicinfo;

import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.user.basicinfo.BuilderSortEnum;
import com.bxm.lovelink.common.dal.user.basicinfo.UserBasicInfoBuilder;
import com.bxm.lovelink.common.dal.user.basicinfo.UserBasicInfoBuilderContext;
import com.bxm.lovelink.common.integration.geo.GaoDeoIntegration;
import org.springframework.stereotype.Component;

@Component
public class UserBasicInfoReGeoBuilder
implements UserBasicInfoBuilder {
    private final GaoDeoIntegration gaoDeoIntegration;

    public UserBasicInfoReGeoBuilder(GaoDeoIntegration gaoDeoIntegration) {
        this.gaoDeoIntegration = gaoDeoIntegration;
    }

    @Override
    public void buildAndCheck(UserBasicInfoBuilderContext context, UserBasicInfo userBasicInfo) {
        Double longitude = userBasicInfo.getLongitude();
        Double latitude = userBasicInfo.getLatitude();
        if (longitude == null || latitude == null) {
            return;
        }
        Integer district = this.gaoDeoIntegration.reGeo(longitude, latitude);
        userBasicInfo.setLastLoginDistrict(district);
    }

    public int getOrder() {
        return BuilderSortEnum.RE_GEO.getCode();
    }
}

