/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.dal.user.basicinfo;

import com.bxm.lovelink.common.dal.entity.UserAboutMe;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.service.ISensitiveService;
import com.bxm.lovelink.common.dal.user.basicinfo.BuilderSortEnum;
import com.bxm.lovelink.common.dal.user.basicinfo.UserBasicInfoBuilder;
import com.bxm.lovelink.common.dal.user.basicinfo.UserBasicInfoBuilderContext;
import com.bxm.lovelink.common.integration.sensitive.SensitiveTextResult;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class UserBasicInfoSensitiveBuilder
implements UserBasicInfoBuilder {
    private final ISensitiveService sensitiveService;

    public UserBasicInfoSensitiveBuilder(ISensitiveService sensitiveService) {
        this.sensitiveService = sensitiveService;
    }

    @Override
    public void buildAndCheck(UserBasicInfoBuilderContext context, UserBasicInfo userBasicInfo) {
        SensitiveTextResult sensitiveTextResult;
        SensitiveTextResult sensitiveTextResult2;
        String nickname = userBasicInfo.getNickname();
        if (StringUtils.isNotBlank((String)nickname) && (sensitiveTextResult2 = this.sensitiveService.checkText(nickname)).getHit().booleanValue()) {
            throw new IllegalArgumentException("\u6635\u79f0\u4e2d\u5305\u542b\u654f\u611f\u8bcd\u6c47");
        }
        String job = userBasicInfo.getJob();
        if (StringUtils.isNotBlank((String)job) && (sensitiveTextResult = this.sensitiveService.checkText(job)).getHit().booleanValue()) {
            throw new IllegalArgumentException("\u5de5\u4f5c\u4e2d\u5305\u542b\u654f\u611f\u8bcd\u6c47");
        }
        List<UserAboutMe> aboutMe = userBasicInfo.getAboutMe();
        if (CollectionUtils.isNotEmpty(aboutMe)) {
            for (UserAboutMe userAboutMe : aboutMe) {
                SensitiveTextResult sensitiveTextResult3 = this.sensitiveService.checkText(userAboutMe.getContent());
                if (!sensitiveTextResult3.getHit().booleanValue()) continue;
                throw new IllegalArgumentException("\u5173\u4e8e\u6211\u5185\u5bb9\u4e2d\u5305\u542b\u654f\u611f\u8bcd");
            }
        }
    }

    public int getOrder() {
        return BuilderSortEnum.SENSITIVE.getCode();
    }
}

