/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.enums;

import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public enum UserBasicInfoCompletionEnum {
    NICKNAME_IMAGE("\u6635\u79f0\u5934\u50cf", userBasicInfo -> StringUtils.isNotBlank((String)userBasicInfo.getNickname()) && StringUtils.isNotBlank((String)userBasicInfo.getAvatar())),
    VOICE("\u58f0\u97f3", userBasicInfo -> StringUtils.isNotBlank((String)userBasicInfo.getVoice())),
    ALBUM("\u76f8\u518c", userBasicInfo -> CollectionUtils.isNotEmpty(userBasicInfo.getAlbum())),
    ABOUT_ME("\u5173\u4e8e\u6211", userBasicInfo -> CollectionUtils.isNotEmpty(userBasicInfo.getAboutMe())),
    LOVE_GOAL("\u604b\u7231\u76ee\u6807", userBasicInfo -> userBasicInfo.getLoveGoal() != null),
    BASIC("\u57fa\u7840\u4fe1\u606f", userBasicInfo -> userBasicInfo.getBirthday() != null && userBasicInfo.getHeight() != null && userBasicInfo.getCurrentPlaceDistrict() != null && userBasicInfo.getNativePlaceDistrict() != null && userBasicInfo.getGender() != null && userBasicInfo.getMarriage() != null && StringUtils.isNotBlank((String)userBasicInfo.getWechatNumber()) && userBasicInfo.getChildren() != null && StringUtils.isNotBlank((String)userBasicInfo.getSchoolName()) && userBasicInfo.getEduHighest() != null && StringUtils.isNotBlank((String)userBasicInfo.getIndustry()) && StringUtils.isNotBlank((String)userBasicInfo.getJob()) && userBasicInfo.getYearRevenue() != null && userBasicInfo.getCar() != null && userBasicInfo.getHouse() != null),
    INTEREST("\u5174\u8da3\u7231\u597d", userBasicInfo -> CollectionUtils.isNotEmpty(userBasicInfo.getInterestTag()));

    private final String desc;
    private final Function<UserBasicInfo, Boolean> infoCompletion;

    public static Integer calculateCompletion(UserBasicInfo userBasicInfo) {
        int size = 0;
        int len = UserBasicInfoCompletionEnum.values().length;
        for (UserBasicInfoCompletionEnum completionEnum : UserBasicInfoCompletionEnum.values()) {
            if (!completionEnum.infoCompletion.apply(userBasicInfo).booleanValue()) continue;
            ++size;
        }
        if (size == len) {
            return 100;
        }
        return 100 / len * size;
    }

    private UserBasicInfoCompletionEnum(String desc, Function<UserBasicInfo, Boolean> infoCompletion) {
        this.desc = desc;
        this.infoCompletion = infoCompletion;
    }

    public String getDesc() {
        return this.desc;
    }

    public Function<UserBasicInfo, Boolean> getInfoCompletion() {
        return this.infoCompletion;
    }
}

