/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.enums;

import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.bo.CalculateUserLoveConditionBo;
import com.bxm.lovelink.common.dal.entity.vo.user.UserLoveConditionRangeVo;
import java.util.function.Function;

public enum UserLoveConditionCalculateEnum {
    AGE(1, o -> {
        int age = (Integer)o.getValue();
        return new UserLoveConditionRangeVo().setMin(age - 5).setMax(age + 5);
    }),
    HEIGHT(2, o -> {
        int height = (Integer)o.getValue();
        UserBasicInfo userBasicInfo = o.getUserComposite().getUserBasicInfo();
        if (userBasicInfo.isMan()) {
            return new UserLoveConditionRangeVo().setMin(height - 10).setMax(height);
        }
        return new UserLoveConditionRangeVo().setMin(height - 5).setMax(height + 15);
    });

    private final Integer type;
    private final Function<CalculateUserLoveConditionBo, UserLoveConditionRangeVo> calculateCondition;

    public static UserLoveConditionCalculateEnum getEnumByType(Integer type) {
        for (UserLoveConditionCalculateEnum e : UserLoveConditionCalculateEnum.values()) {
            if (!e.getType().equals(type)) continue;
            return e;
        }
        return null;
    }

    private UserLoveConditionCalculateEnum(Integer type, Function<CalculateUserLoveConditionBo, UserLoveConditionRangeVo> calculateCondition) {
        this.type = type;
        this.calculateCondition = calculateCondition;
    }

    public Integer getType() {
        return this.type;
    }

    public Function<CalculateUserLoveConditionBo, UserLoveConditionRangeVo> getCalculateCondition() {
        return this.calculateCondition;
    }
}

