/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.enums;

import com.bxm.lovelink.common.dal.entity.UserLoveCondition;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;

public enum UserLoveConditionCompletionEnum {
    HEIGHT("\u8eab\u9ad8", loveCondition -> loveCondition.getHeightRangeMin() != null && loveCondition.getHeightRangeMax() != null),
    AGE("\u5e74\u9f84", loveCondition -> loveCondition.getAgeRangeMin() != null && loveCondition.getAgeRangeMax() != null),
    EDU("\u5b66\u5386", loveCondition -> UserLoveConditionCompletionEnum.notNull(loveCondition.getEduRange())),
    YEAR_INCOME("\u5e74\u6536\u5165", loveCondition -> UserLoveConditionCompletionEnum.notNull(loveCondition.getYearRevenueRange())),
    CAR("\u8f66", loveCondition -> UserLoveConditionCompletionEnum.notNull(loveCondition.getCarRange())),
    HOUSE("\u623f", loveCondition -> UserLoveConditionCompletionEnum.notNull(loveCondition.getHouseRange()));

    private final String desc;
    private final Function<UserLoveCondition, Boolean> infoCompletion;

    public static Integer calculateCompletion(UserLoveCondition loveCondition) {
        int size = 0;
        int len = UserLoveConditionCompletionEnum.values().length;
        for (UserLoveConditionCompletionEnum completionEnum : UserLoveConditionCompletionEnum.values()) {
            if (!completionEnum.infoCompletion.apply(loveCondition).booleanValue()) continue;
            ++size;
        }
        if (size == len) {
            return 100;
        }
        return 100 / len * size;
    }

    private static boolean notNull(List<Integer> value) {
        return CollectionUtils.isNotEmpty(value);
    }

    private UserLoveConditionCompletionEnum(String desc, Function<UserLoveCondition, Boolean> infoCompletion) {
        this.desc = desc;
        this.infoCompletion = infoCompletion;
    }

    public String getDesc() {
        return this.desc;
    }

    public Function<UserLoveCondition, Boolean> getInfoCompletion() {
        return this.infoCompletion;
    }
}

