/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.enums;

import com.bxm.lovelink.common.dal.entity.UserAlbum;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.UserCert;
import com.bxm.lovelink.common.dal.entity.UserComposite;
import com.bxm.lovelink.common.dal.entity.UserLoveCondition;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public enum UserRegisterPageEnum {
    GENDER_BIRTHDAY("register_gender_birthday", userBasicInfo -> userBasicInfo.getGender() != null && userBasicInfo.getBirthday() != null),
    HEIGHT("register_height", userBasicInfo -> userBasicInfo.getHeight() != null),
    PALACE("register_place", userBasicInfo -> userBasicInfo.getCurrentPlaceDistrict() != null && userBasicInfo.getNativePlaceDistrict() != null),
    EDU("register_edu", userBasicInfo -> userBasicInfo.getEduHighest() != null),
    SCHOOL("register_school", userBasicInfo -> StringUtils.isNotBlank((CharSequence)userBasicInfo.getSchoolName())),
    INDUSTRY_JOB_REVENUE("register_job_revenue", userBasicInfo -> StringUtils.isNotBlank((CharSequence)userBasicInfo.getJob()) && userBasicInfo.getYearRevenue() != null),
    MARRIAGE("register_marriage", userBasicInfo -> userBasicInfo.getMarriage() != null),
    NICKNAME("register_nickname", userBasicInfo -> StringUtils.isNotBlank((CharSequence)userBasicInfo.getNickname())),
    AVATAR("register_avatar", userBasicInfo -> StringUtils.isNotBlank((CharSequence)userBasicInfo.getAvatar()) && StringUtils.isNotBlank((CharSequence)userBasicInfo.getCardImage())),
    NICKNAME_AVATAR("register_nickname_avatar", userBasicInfo -> StringUtils.isNotBlank((CharSequence)userBasicInfo.getNickname()) && StringUtils.isNotBlank((CharSequence)userBasicInfo.getAvatar())),
    BASIC_SIX("register_basic_four", userBasicInfo -> userBasicInfo.getHeight() != null && StringUtils.isNotBlank((CharSequence)userBasicInfo.getSchoolName()) && userBasicInfo.getMarriage() != null && StringUtils.isNotBlank((CharSequence)userBasicInfo.getJob()) && userBasicInfo.getYearRevenue() != null && CollectionUtils.isNotEmpty(userBasicInfo.getAboutMe()) && CollectionUtils.isNotEmpty(userBasicInfo.getInterestTag())),
    ABOUT_ME("register_about_me", userBasicInfo -> CollectionUtils.isNotEmpty(userBasicInfo.getAboutMe())),
    INTEREST("register_interest", userBasicInfo -> CollectionUtils.isNotEmpty(userBasicInfo.getInterestTag()));

    private final String code;
    private final Function<UserBasicInfo, Boolean> validator;

    public static boolean registerInfoFinished(UserBasicInfo userBasicInfo, String code) {
        for (UserRegisterPageEnum x : UserRegisterPageEnum.values()) {
            if (!x.code.equals(code)) continue;
            return x.validator.apply(userBasicInfo);
        }
        return true;
    }

    public static int calculateCompletionStatus(UserComposite userComposite) {
        Predicate validator;
        ArrayList validators = Lists.newArrayList((Object[])new Predicate[]{UserRegisterPageEnum::isNicknameAvatarComplete, UserRegisterPageEnum::isAlbumComplete, UserRegisterPageEnum::isBasicSixComplete, UserRegisterPageEnum::isCertsComplete, UserRegisterPageEnum::isLoveConditionComplete});
        int size = 0;
        Iterator iterator = validators.iterator();
        while (iterator.hasNext() && (validator = (Predicate)iterator.next()).test(userComposite)) {
            ++size;
        }
        return size;
    }

    public static boolean isNicknameAvatarComplete(UserComposite userComposite) {
        UserBasicInfo userBasicInfo = userComposite.getUserBasicInfo();
        return UserRegisterPageEnum.NICKNAME_AVATAR.validator.apply(userBasicInfo);
    }

    public static boolean isAlbumComplete(UserComposite userComposite) {
        UserBasicInfo userBasicInfo = userComposite.getUserBasicInfo();
        List<UserAlbum> album = userBasicInfo.getAlbum();
        return album != null && album.size() >= 2;
    }

    public static boolean isBasicSixComplete(UserComposite userComposite) {
        UserBasicInfo userBasicInfo = userComposite.getUserBasicInfo();
        return UserRegisterPageEnum.BASIC_SIX.validator.apply(userBasicInfo);
    }

    public static boolean isCertsComplete(UserComposite userComposite) {
        List<UserCert> userCerts = userComposite.getUserCerts();
        if (userCerts == null) {
            return false;
        }
        long certCount = userCerts.stream().filter(UserCert::isSuccess).filter(cert -> Objects.equals(cert.getCertType(), UserCert.TYPE_REAL_NAME) || Objects.equals(cert.getCertType(), UserCert.TYPE_MARRIAGE)).count();
        return certCount >= 2L;
    }

    public static boolean isLoveConditionComplete(UserComposite userComposite) {
        UserLoveCondition loveCondition = userComposite.getUserLoveCondition();
        return loveCondition != null && Objects.equals(loveCondition.getInfoCompleteProgress(), 100);
    }

    private UserRegisterPageEnum(String code, Function<UserBasicInfo, Boolean> validator) {
        this.code = code;
        this.validator = validator;
    }
}

