/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.enums;

import com.bxm.lovelink.common.contant.UserConstants;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.UserComposite;
import com.bxm.lovelink.common.dal.entity.UserRuleTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public enum UserRuleTagEnum {
    EDU(1, "\u5b66\u5386\u6807\u7b7e\uff0c\u672c\u79d1\u53ca\u4ee5\u4e0a\u6709", new Function<UserComposite, String>(){

        @Override
        public String apply(UserComposite userComposite) {
            UserBasicInfo basicInfo = userComposite.getUserBasicInfo();
            Integer edu = basicInfo.getEduHighest();
            return UserRuleTagEnum.getRuleTagName(UserConstants.EduHighestEnum.BACHELOR, edu);
        }
    }),
    YEAR_REVENUE(2, "\u5e74\u6536\u5165\u6807\u7b7e\uff0c\u5927\u4e8e25\u4e07\u6709\u5e74\u6536\u5165\u7684\u6807\u7b7e\uff0c\u5c55\u793a\u5177\u4f53\u5e74\u6536\u5165\u533a\u95f4", new Function<UserComposite, String>(){

        @Override
        public String apply(UserComposite userComposite) {
            UserBasicInfo basicInfo = userComposite.getUserBasicInfo();
            Integer yearRevenue = basicInfo.getYearRevenue();
            return UserRuleTagEnum.getRuleTagName(UserConstants.YearRevenueEnum.FROM_20K_TO_30K, yearRevenue);
        }
    }),
    CAR(3, "\u9700\u8f66\u8ba4\u8bc1\u901a\u8fc7", new Function<UserComposite, String>(){

        @Override
        public String apply(UserComposite userComposite) {
            UserBasicInfo basicInfo = userComposite.getUserBasicInfo();
            Integer car = basicInfo.getCar();
            if (UserConstants.CarEnum.HAS_CAR.getCode().equals(car)) {
                return "\u6709\u8f66";
            }
            return null;
        }
    }),
    HOUSE(4, "\u9700\u623f\u4ea7\u8ba4\u8bc1\u901a\u8fc7", new Function<UserComposite, String>(){

        @Override
        public String apply(UserComposite userComposite) {
            UserBasicInfo basicInfo = userComposite.getUserBasicInfo();
            Integer house = basicInfo.getHouse();
            if (UserConstants.HouseEnum.HAS_HOUSE.getCode().equals(house)) {
                return "\u6709\u623f";
            }
            return null;
        }
    }),
    SCHOOL(5, "\u5b66\u6821", new Function<UserComposite, String>(){

        @Override
        public String apply(UserComposite userComposite) {
            UserBasicInfo basicInfo = userComposite.getUserBasicInfo();
            String schoolName = basicInfo.getSchoolName();
            if (StringUtils.isBlank((CharSequence)schoolName) || !basicInfo.isSchoolDisplay()) {
                return null;
            }
            return schoolName;
        }
    }),
    HEIGHT(6, "\u8eab\u9ad8", new Function<UserComposite, String>(){

        @Override
        public String apply(UserComposite userComposite) {
            UserBasicInfo basicInfo = userComposite.getUserBasicInfo();
            Integer height = basicInfo.getHeight();
            if (height == null || basicInfo.getGender() == null) {
                return null;
            }
            if (basicInfo.isMan() && height >= 175) {
                return height + "cm";
            }
            if (!basicInfo.isMan() && height >= 160) {
                return height + "cm";
            }
            return null;
        }
    }),
    CONSTELLATION(7, "\u661f\u5ea7", new Function<UserComposite, String>(){

        @Override
        public String apply(UserComposite userComposite) {
            UserBasicInfo basicInfo = userComposite.getUserBasicInfo();
            Integer constellation = basicInfo.getConstellation();
            if (constellation == null) {
                return null;
            }
            UserConstants.UserConstellationEnum byCode = UserConstants.UserConstellationEnum.getByCode(constellation);
            if (byCode == null) {
                return null;
            }
            return byCode.getName();
        }
    }),
    HIGH_JOB(8, "\u9ad8\u7ea7\u804c\u4e1a", null);

    private final Integer type;
    private final String desc;
    private final Function<UserComposite, String> calculate;

    public static List<UserRuleTag> getUserRuleTags(UserComposite userComposite) {
        ArrayList<UserRuleTag> userRuleTags = new ArrayList<UserRuleTag>();
        for (UserRuleTagEnum x : UserRuleTagEnum.values()) {
            String apply;
            if (x.calculate == null || (apply = x.calculate.apply(userComposite)) == null) continue;
            userRuleTags.add(new UserRuleTag().setType(x.getType()).setName(apply));
        }
        return userRuleTags;
    }

    private static String getRuleTagName(UserConstants.BaseEnum ruleLine, Integer code) {
        if (code == null || ruleLine == null) {
            return null;
        }
        Integer ruleLineCode = ruleLine.getCode();
        if (code < ruleLineCode) {
            return null;
        }
        for (UserConstants.BaseEnum baseEnum : (UserConstants.BaseEnum[])ruleLine.getClass().getEnumConstants()) {
            if (!Objects.equals(baseEnum.getCode(), code)) continue;
            return baseEnum.getName();
        }
        return null;
    }

    private UserRuleTagEnum(Integer type, String desc, Function<UserComposite, String> calculate) {
        this.type = type;
        this.desc = desc;
        this.calculate = calculate;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public Function<UserComposite, String> getCalculate() {
        return this.calculate;
    }
}

