/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.integration.geo;

import com.bxm.lovelink.common.exception.BusinessException;
import com.bxm.lovelink.common.integration.geo.GaoDeProperties;
import com.bxm.lovelink.common.integration.geo.GaoDeReGeoResult;
import com.bxm.warcar.utils.HttpClientHelper;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={GaoDeProperties.class})
public class GaoDeoIntegration {
    private static final Logger log = LoggerFactory.getLogger(GaoDeoIntegration.class);
    private final HttpClient httpClient;
    private final GaoDeProperties properties;
    private static final String RE_GEO = "https://restapi.amap.com/v3/geocode/regeo";

    public GaoDeoIntegration(GaoDeProperties properties) {
        this.properties = properties;
        this.httpClient = HttpClientHelper.createHttpClient((int)50, (int)50, (int)5000, (int)5000, (int)5000);
    }

    public Integer reGeo(Double longitude, Double latitude) {
        String url = "https://restapi.amap.com/v3/geocode/regeo?key=" + this.properties.getKey() + "&location=" + longitude + "," + latitude;
        HttpGet get = new HttpGet(url);
        String errorMessage = "reGeo error";
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            int statusCode = response.getStatusLine().getStatusCode();
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            if (statusCode != 200 || StringUtils.isBlank((String)body)) {
                log.error(errorMessage + ",statusCode: {},longitude:{},latitude:{},response:{}", new Object[]{statusCode, longitude, latitude, body});
                throw new BusinessException(errorMessage);
            }
            GaoDeReGeoResult rs = (GaoDeReGeoResult)JsonHelper.convert((String)body, GaoDeReGeoResult.class);
            if (!rs.isSuccess()) {
                log.error(errorMessage + ",longitude:{},latitude:{},response:{}", new Object[]{longitude, latitude, body});
                throw new BusinessException(errorMessage);
            }
            Integer n = rs.getAdcode();
            return n;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(errorMessage + ",longitude:{},latitude:{}", new Object[]{longitude, latitude, e});
            throw new BusinessException(errorMessage);
        }
        finally {
            get.releaseConnection();
        }
    }
}

