/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.integration.sensitive;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNull;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SensitiveAspect
implements MeterBinder {
    private static final Logger log = LoggerFactory.getLogger(SensitiveAspect.class);
    private MeterRegistry registry;

    public void bindTo(@NonNull MeterRegistry registry) {
        this.registry = registry;
    }

    @Around(value="execution(* com.bxm.lovelink.common.integration.sensitive.SensitiveImageIntegration.checkImage(..))")
    public Object aroundImage(ProceedingJoinPoint point) throws Throwable {
        return this.around0(point, 1);
    }

    @Around(value="execution(* com.bxm.lovelink.common.integration.sensitive.SensitiveTextIntegration.checkText(..))")
    public Object aroundText(ProceedingJoinPoint point) throws Throwable {
        return this.around0(point, 2);
    }

    public Object around0(ProceedingJoinPoint point, Integer business) throws Throwable {
        String name = point.getTarget().getClass().getName();
        name = name.substring(name.lastIndexOf(".") + 1);
        long start = System.nanoTime();
        int status = 1;
        try {
            Object object = point.proceed();
            return object;
        }
        catch (Exception e) {
            status = 0;
            throw e;
        }
        finally {
            Timer.builder((String)"sensitive.execute").tag("type", name).tag("business", String.valueOf(business)).tag("status", String.valueOf(status)).register(this.registry).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }
}

