/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.integration.sensitive.nut;

import com.alibaba.fastjson.JSON;
import com.bxm.lovelink.common.exception.BusinessException;
import com.bxm.lovelink.common.integration.sensitive.SensitiveTextIntegration;
import com.bxm.lovelink.common.integration.sensitive.SensitiveTextResult;
import com.bxm.lovelink.common.integration.sensitive.nut.NutWallSensitiveProperties;
import com.bxm.lovelink.common.integration.sensitive.nut.NutWallTextSensitiveRequest;
import com.bxm.lovelink.common.integration.sensitive.nut.NutWallTextSensitiveResponse;
import com.bxm.warcar.utils.HttpClientHelper;
import com.bxm.warcar.utils.JsonHelper;
import java.nio.charset.StandardCharsets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="sensitive.nut-wall", name={"enable"}, havingValue="true")
public class NutWallSensitiveIntegration
implements SensitiveTextIntegration {
    private static final Logger log = LoggerFactory.getLogger(NutWallSensitiveIntegration.class);
    private final NutWallSensitiveProperties properties;
    private final HttpClient httpClient;

    public NutWallSensitiveIntegration(NutWallSensitiveProperties properties) {
        this.properties = properties;
        this.httpClient = HttpClientHelper.createHttpClient((int)50, (int)50, (int)5000, (int)5000, (int)5000);
    }

    @Override
    public SensitiveTextResult checkText(String text) {
        NutWallTextSensitiveRequest request = new NutWallTextSensitiveRequest().setContent(text);
        HttpPost post = new HttpPost(this.properties.getUrl());
        post.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)request), StandardCharsets.UTF_8));
        post.addHeader("content-type", "application/json;charset=utf-8");
        String errorMessage = "text check error";
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200 || StringUtils.isBlank((String)body)) {
                log.error(errorMessage + ",statusCode: {},text: {}, response: {}", new Object[]{statusCode, text, body});
                throw new BusinessException(errorMessage);
            }
            NutWallTextSensitiveResponse rs = (NutWallTextSensitiveResponse)JsonHelper.convert((String)body, NutWallTextSensitiveResponse.class);
            if (!"0".equals(rs.getCode())) {
                log.error(errorMessage + ",text: {},response: {}", (Object)text, (Object)body);
                throw new BusinessException(errorMessage);
            }
            SensitiveTextResult sensitiveTextResult = new SensitiveTextResult().setHit(CollectionUtils.isNotEmpty(rs.getWord_list())).setText(rs.getReturn_str());
            return sensitiveTextResult;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(errorMessage + ",text: {}", (Object)text, (Object)e);
            throw new BusinessException(errorMessage);
        }
        finally {
            post.releaseConnection();
        }
    }
}

