/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.integration.sensitive.wangyi;

import com.alibaba.fastjson.JSON;
import com.bxm.lovelink.common.exception.BusinessException;
import com.bxm.lovelink.common.integration.sensitive.SensitiveImageIntegration;
import com.bxm.lovelink.common.integration.sensitive.SensitiveImageResult;
import com.bxm.lovelink.common.integration.sensitive.SensitiveImageType;
import com.bxm.lovelink.common.integration.sensitive.SensitiveTextIntegration;
import com.bxm.lovelink.common.integration.sensitive.SensitiveTextResult;
import com.bxm.lovelink.common.integration.sensitive.wangyi.WangYiSensitiveProperties;
import com.google.common.collect.Lists;
import com.netease.yidun.sdk.antispam.AntispamRequester;
import com.netease.yidun.sdk.antispam.image.v5.ImageClient;
import com.netease.yidun.sdk.antispam.image.v5.check.ImageV5CheckRequest;
import com.netease.yidun.sdk.antispam.image.v5.check.sync.request.ImageV5SyncCheckRequest;
import com.netease.yidun.sdk.antispam.image.v5.check.sync.response.ImageV5CheckResponse;
import com.netease.yidun.sdk.antispam.image.v5.check.sync.response.ImageV5Result;
import com.netease.yidun.sdk.antispam.text.TextClient;
import com.netease.yidun.sdk.antispam.text.v5.check.sync.single.TextCheckRequest;
import com.netease.yidun.sdk.antispam.text.v5.check.sync.single.TextCheckResponse;
import com.netease.yidun.sdk.antispam.text.v5.check.sync.single.TextCheckResult;
import com.netease.yidun.sdk.core.auth.Credentials;
import com.netease.yidun.sdk.core.client.ClientProfile;
import com.netease.yidun.sdk.core.http.HttpClientConfig;
import com.netease.yidun.sdk.core.response.CommonResponse;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="sensitive.wang-yi", name={"enable"}, havingValue="true")
public class WangYiSensitiveIntegration
implements SensitiveImageIntegration,
SensitiveTextIntegration {
    private static final Logger log = LoggerFactory.getLogger(WangYiSensitiveIntegration.class);
    private final WangYiSensitiveProperties properties;
    private final ImageClient imageClient;
    private final TextClient textClient;

    public WangYiSensitiveIntegration(WangYiSensitiveProperties properties) {
        this.properties = properties;
        this.imageClient = ImageClient.getInstance((AntispamRequester)AntispamRequester.getInstance((ClientProfile)this.createProfile()));
        this.textClient = TextClient.getInstance((AntispamRequester)AntispamRequester.getInstance((ClientProfile)this.createProfile()));
    }

    @Override
    public SensitiveImageResult checkImage(Integer type, String imgUrl) {
        ImageV5CheckResponse checkResponse;
        String businessId = this.properties.getAvatarBusinessId();
        if (Objects.equals(SensitiveImageType.LIFE, type)) {
            businessId = this.properties.getLifeBusinessId();
        }
        SensitiveImageResult result = new SensitiveImageResult().setImgUrl(imgUrl);
        String errorMessage = "wangYi check image error";
        if (StringUtils.isEmpty((String)imgUrl)) {
            return result;
        }
        ImageV5SyncCheckRequest checkRequest = new ImageV5SyncCheckRequest();
        checkRequest.setBusinessId(businessId);
        ImageV5CheckRequest.ImageBeanRequest image = new ImageV5CheckRequest.ImageBeanRequest();
        image.setData(imgUrl);
        image.setName("1");
        image.setType(Integer.valueOf(1));
        checkRequest.setImages((List)Lists.newArrayList((Object[])new ImageV5CheckRequest.ImageBeanRequest[]{image}));
        try {
            checkResponse = this.imageClient.syncCheckImage(checkRequest);
        }
        catch (Exception e) {
            log.error(errorMessage + ",url:{}", (Object)imgUrl, (Object)e);
            throw new BusinessException(errorMessage);
        }
        if (this.fail((CommonResponse)checkResponse)) {
            log.error(errorMessage + ",url:{},data:{}", (Object)imgUrl, (Object)JSON.toJSONString((Object)checkResponse));
            throw new BusinessException(errorMessage);
        }
        ImageV5Result imageV5Result = (ImageV5Result)checkResponse.getResult().get(0);
        result.setHit(!Objects.equals(imageV5Result.getAntispam().getSuggestion(), 0));
        return result;
    }

    @Override
    public SensitiveTextResult checkText(String text) {
        TextCheckResponse checkResponse;
        SensitiveTextResult textResult = new SensitiveTextResult().setText(text);
        if (StringUtils.isEmpty((String)text)) {
            return textResult;
        }
        TextCheckRequest checkRequest = new TextCheckRequest();
        checkRequest.setBusinessId(this.properties.getTextBusinessId());
        checkRequest.setDataId("1");
        checkRequest.setContent(text);
        String errorMessage = "wangYi text check error";
        try {
            checkResponse = this.textClient.syncCheckText(checkRequest);
        }
        catch (Exception e) {
            log.error(errorMessage + ",text:{}", (Object)text, (Object)e);
            throw new BusinessException(errorMessage);
        }
        if (this.fail((CommonResponse)checkResponse)) {
            log.error(errorMessage + ",text:{},data:{}", (Object)text, (Object)JSON.toJSONString((Object)checkResponse));
            throw new BusinessException(errorMessage);
        }
        TextCheckResult.Antispam antispam = checkResponse.getResult().getAntispam();
        if (!Objects.equals(antispam.getSuggestion(), 0)) {
            textResult.setHit(true);
            textResult.setText(antispam.getFilteredContent());
        }
        return textResult;
    }

    private ClientProfile createProfile() {
        ClientProfile clientProfile = ClientProfile.defaultProfile((Credentials)new Credentials(this.properties.getSecretId(), this.properties.getSecretKey()));
        HttpClientConfig httpClientConfig = new HttpClientConfig();
        httpClientConfig.setMaxConnectionCountPerRoute(20);
        httpClientConfig.setMaxConnectionCount(20);
        httpClientConfig.setConnectionRequestTimeoutMillis(1000L);
        httpClientConfig.setConnectionTimeoutMillis(2000L);
        httpClientConfig.socketTimeoutMillis(3000);
        clientProfile.setHttpClientConfig(httpClientConfig);
        return clientProfile;
    }

    private boolean fail(CommonResponse response) {
        return Objects.isNull(response) || !Objects.equals(response.getCode(), 200);
    }
}

