/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.integration.sms.submail;

import com.alibaba.fastjson.JSON;
import com.bxm.lovelink.common.exception.BusinessException;
import com.bxm.lovelink.common.integration.sms.submail.SubMailSmsProperties;
import com.bxm.lovelink.common.integration.sms.submail.SubMailSmsRequest;
import com.bxm.lovelink.common.integration.sms.submail.SubMailSmsResponse;
import com.bxm.warcar.utils.HttpClientHelper;
import com.bxm.warcar.utils.JsonHelper;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SubMailSmsProperties.class})
public class SubMailSmsIntegration {
    private static final Logger log = LoggerFactory.getLogger(SubMailSmsIntegration.class);
    private final HttpClient httpClient;
    private final SubMailSmsProperties properties;
    private static final String SMS_URL = "https://api-v4.mysubmail.com/sms/send.json";
    private static final String SMS_TEMPLATE_URL = "https://api-v4.mysubmail.com/sms/xsend.json";

    public SubMailSmsIntegration(SubMailSmsProperties properties) {
        this.properties = properties;
        this.httpClient = HttpClientHelper.createHttpClient((int)50, (int)50, (int)5000, (int)5000, (int)5000);
    }

    public void send(String to, String content) {
        SubMailSmsRequest message = new SubMailSmsRequest().setAppid(this.properties.getAppid()).setSignature(this.properties.getSignature()).setTo(to).setContent(content);
        this.doSend(message, SMS_URL);
    }

    public void sendByTemplate(String to, String templateId, String vars) {
        SubMailSmsRequest message = new SubMailSmsRequest().setAppid(this.properties.getAppid()).setSignature(this.properties.getSignature()).setTo(to).setProject(templateId).setVars(vars);
        this.doSend(message, SMS_TEMPLATE_URL);
    }

    public void doSend(SubMailSmsRequest message, String url) {
        String reqInfo = JSON.toJSONString((Object)message);
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new StringEntity(JSON.toJSONString((Object)message), StandardCharsets.UTF_8));
        post.addHeader("content-type", "application/json;charset=utf-8");
        String errorMessage = "message send error";
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            if (statusCode != 200 || StringUtils.isBlank((String)body)) {
                log.error(errorMessage + ",statusCode: {},message: {}, response: {}", new Object[]{statusCode, reqInfo, body});
                throw new BusinessException(errorMessage);
            }
            log.info("{} - {}", (Object)message.getTo(), (Object)body);
            SubMailSmsResponse rs = (SubMailSmsResponse)JsonHelper.convert((String)body, SubMailSmsResponse.class);
            if (!"success".equals(rs.getStatus())) {
                log.error(errorMessage + ",message:{}, response: {}", (Object)reqInfo, (Object)body);
                throw new BusinessException(errorMessage);
            }
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(errorMessage + ",message:{}", (Object)reqInfo, (Object)e);
            throw new BusinessException(errorMessage);
        }
        finally {
            post.releaseConnection();
        }
    }
}

