/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.integration.uni.push;

import com.alibaba.fastjson.JSON;
import com.bxm.lovelink.common.integration.uni.UniProperties;
import com.bxm.lovelink.common.integration.uni.push.UniappPushMsgRequest;
import com.bxm.lovelink.common.integration.uni.push.UniappResult;
import com.bxm.warcar.utils.HttpClientHelper;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={UniProperties.class})
public class UniPushIntegration {
    private static final Logger log = LoggerFactory.getLogger(UniPushIntegration.class);
    private final HttpClient httpClient;
    private final UniProperties properties;
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(100, 100, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("uniapp-push"));

    public UniPushIntegration(UniProperties properties) {
        this.properties = properties;
        this.httpClient = HttpClientHelper.createHttpClient((int)500, (int)500, (int)2000, (int)1000, (int)2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(UniappPushMsgRequest uniappPushMsgRequest) {
        HttpPost post = new HttpPost(this.properties.getDomain() + "nuannuan/sendMessage");
        try {
            UniappResult rs;
            post.addHeader("Content-Type", "application/json;charset=UTF-8");
            post.addHeader(this.properties.getAuthHeaderName(), this.properties.getAuthHeaderValue());
            post.setEntity((HttpEntity)new StringEntity(JsonHelper.convert((Object)uniappPushMsgRequest), StandardCharsets.UTF_8));
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            if (statusCode != 200 || StringUtils.isBlank((String)body)) {
                log.error("\u72b6\u6001\u7801\u4e0d\u5bf9");
            }
            if (!(rs = (UniappResult)JsonHelper.convert((String)body, UniappResult.class)).isSuccess()) {
                log.error("UniappResult  return error,{}", (Object)body);
            }
            log.info("request params is {}, result body {}", (Object)JSON.toJSONString((Object)uniappPushMsgRequest), (Object)JSON.toJSONString((Object)body));
        }
        catch (Exception e) {
            log.error("UniappResult Exception", (Throwable)e);
        }
        finally {
            post.releaseConnection();
        }
    }

    public static void main(String[] args) {
    }
}

