/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.integration.wechat;

import com.alibaba.fastjson.JSON;
import com.bxm.lovelink.common.exception.BusinessException;
import com.bxm.lovelink.common.integration.wechat.AccessTokenResponse;
import com.bxm.warcar.utils.HttpClientHelper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WechatAuthIntegration {
    private static final Logger log = LoggerFactory.getLogger(WechatAuthIntegration.class);
    private final HttpClient httpClient = HttpClientHelper.createHttpClient((int)50, (int)50, (int)5000, (int)5000, (int)5000);
    private static final String ACCESS_TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/access_token";

    public AccessTokenResponse auth(String code, String appId, String appSecret) {
        String param = "?appid=" + appId + "&secret=" + appSecret + "&code=" + code + "&grant_type=authorization_code";
        String errorMessage = "wechat auth error";
        try {
            HttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(ACCESS_TOKEN_URL + param));
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200 || StringUtils.isBlank((CharSequence)json)) {
                log.error(errorMessage + ",statusCode:{}, code:{}, response:{}", new Object[]{statusCode, code, json});
                throw new BusinessException(errorMessage);
            }
            AccessTokenResponse accessTokenResponse = (AccessTokenResponse)JSON.parseObject((String)json, AccessTokenResponse.class);
            if (accessTokenResponse.isSuccess()) {
                return accessTokenResponse;
            }
            log.error(errorMessage + ",code:{}, response:{}", (Object)code, (Object)json);
            throw new BusinessException(errorMessage);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(errorMessage + ", code:{}", (Object)code, (Object)e);
            throw new BusinessException(errorMessage);
        }
    }
}

