/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.listener.chat;

import com.bxm.lovelink.common.chat.ChatStat;
import com.bxm.lovelink.common.dal.entity.ChatSession;
import com.bxm.lovelink.common.dal.service.IChatSessionService;
import com.bxm.lovelink.common.event.chat.ChatCompletionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ChatCompletionUpdateSessionListener
implements EventListener<ChatCompletionEvent> {
    private final IChatSessionService chatSessionService;

    public ChatCompletionUpdateSessionListener(IChatSessionService chatSessionService) {
        this.chatSessionService = chatSessionService;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void consume(ChatCompletionEvent event) {
        ChatSession chatSession = event.getChatSession();
        ChatStat chatStat = event.getChatStat();
        if (null == chatStat) {
            return;
        }
        String cozeBotId = chatStat.getCozeBotId();
        String cozeConversationId = chatStat.getCozeConversationId();
        if (StringUtils.isNotBlank((CharSequence)cozeBotId)) {
            chatSession.setCozeBotId(cozeBotId);
        }
        if (StringUtils.isNotBlank((CharSequence)cozeConversationId)) {
            chatSession.setCozeConversationId(cozeConversationId);
        }
        this.chatSessionService.updateById(chatSession);
    }
}

