/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.push;

import com.alibaba.fastjson.JSON;
import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.service.IUserService;
import com.bxm.lovelink.common.integration.uni.push.UniappPushMsgRequest;
import com.bxm.lovelink.common.push.event.push.PushEvent;
import com.bxm.lovelink.common.push.factory.ImmediatePushSceneService;
import com.bxm.lovelink.common.push.factory.Push;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushSceneServiceFactory;
import com.bxm.lovelink.common.push.factory.PushTarget;
import com.bxm.lovelink.common.push.factory.TimerPushSceneService;
import com.bxm.lovelink.common.push.render.PushRender;
import com.bxm.lovelink.common.push.render.PushRenderFactory;
import com.bxm.warcar.integration.eventbus.EventPark;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class Pusher {
    private static final Logger log = LoggerFactory.getLogger(Pusher.class);
    private final PushSceneServiceFactory pushSceneServiceFactory;
    private final PushRenderFactory pushRenderFactory;
    private final EventPark eventPark;
    private final IUserService userService;

    @Async
    public void doTimerPush(PushScene pushScene) {
        TimerPushSceneService pushSceneService = this.pushSceneServiceFactory.getTimerPushSceneService(pushScene);
        if (pushSceneService == null) {
            log.warn("Unsupported Push Scene: {}", (Object)pushScene);
            return;
        }
        List<Push> targetResultList = pushSceneService.create();
        if (CollectionUtils.isEmpty(targetResultList)) {
            log.warn("targetResultList is not config: {}", (Object)pushScene);
            return;
        }
        for (Push targetResult : targetResultList) {
            this.eventPark.post((EventObject)new PushEvent(this, targetResult));
        }
        pushSceneService.onAfterPostEvent(targetResultList);
    }

    @Async
    public void doImmediatePush(PushScene pushScene, PushTarget pushTarget) {
        ImmediatePushSceneService pushSceneService = this.pushSceneServiceFactory.getImmediatePushSceneService(pushScene);
        if (pushSceneService == null) {
            log.warn("Unsupported Push Scene: {}", (Object)pushScene);
            return;
        }
        List<Push> targetResultList = pushSceneService.create(pushTarget);
        if (CollectionUtils.isEmpty(targetResultList)) {
            log.warn("targetResultList is not config: {}", (Object)pushScene);
            return;
        }
        for (Push targetResult : targetResultList) {
            this.eventPark.post((EventObject)new PushEvent(this, targetResult));
        }
    }

    public UniappPushMsgRequest buildUniappPushMsgRequest(Push push) {
        PushTask pushTask = push.getPushTask();
        PushTarget pushTarget = push.getPushTarget();
        String taskScene = pushTask.getTaskScene();
        PushScene pushScene = PushScene.valueOf(taskScene);
        Long userId = pushTarget.getUserId();
        User user = (User)this.userService.getById(userId);
        if (Objects.isNull(user)) {
            log.info("\u7528\u6237ID\u662f\u7a7a {}", (Object)JSON.toJSONString((Object)push));
            return null;
        }
        String pushClientid = user.getPushClientid();
        if (StringUtils.isBlank((CharSequence)pushClientid)) {
            log.info("\u6ca1\u6709 pushClinentid \u7684\u7528\u6237\u4e0d\u63a8\u9001\u6d88\u606f,\u7528\u6237ID\u662f {}", (Object)userId);
            return null;
        }
        PushRender pushRender = (PushRender)Optional.ofNullable(this.pushRenderFactory.get((Object)pushScene)).orElse(PushRender.SIMPLE);
        String message = pushRender.renderPushMessage(pushTask, pushTarget);
        String payload = pushRender.renderPushPayload(pushTask, pushTarget);
        Map payloadObject = Optional.ofNullable(pushTarget.getPayload()).orElseGet(() -> Collections.singletonMap("path", payload));
        Map<String, Object> extend = pushTarget.getExtend();
        return new UniappPushMsgRequest().setPush_clientid(pushClientid).setContent(message).setTitle(pushTask.getPushTitle()).setPayload(payloadObject).setForce_notification(Objects.isNull(extend.get("force_notification")) || (Boolean)extend.get("force_notification") != false);
    }

    public Pusher(PushSceneServiceFactory pushSceneServiceFactory, PushRenderFactory pushRenderFactory, EventPark eventPark, IUserService userService) {
        this.pushSceneServiceFactory = pushSceneServiceFactory;
        this.pushRenderFactory = pushRenderFactory;
        this.eventPark = eventPark;
        this.userService = userService;
    }
}

