/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.push.factory;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.push.ExceedMaximumCountException;
import com.bxm.lovelink.common.push.ExceedMaximumLifeTimeException;
import com.bxm.lovelink.common.push.TaskRedisKeys;
import com.bxm.lovelink.common.push.factory.Push;
import com.bxm.lovelink.common.push.factory.PushTarget;
import com.bxm.lovelink.common.push.factory.TimerPushSceneService;
import com.bxm.lovelink.common.push.render.PushRender;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public abstract class AbstractTimerPushSceneService
implements TimerPushSceneService,
PushRender {
    private static final Logger log = LoggerFactory.getLogger(AbstractTimerPushSceneService.class);
    private final IPushTaskService pushTaskService;
    private final Fetcher fetcher;
    private final JedisPool jedisPool;

    protected AbstractTimerPushSceneService(IPushTaskService pushTaskService, Fetcher fetcher) {
        this.pushTaskService = pushTaskService;
        this.fetcher = fetcher;
        this.jedisPool = (JedisPool)fetcher.getClientOriginal();
    }

    protected abstract List<PushTarget> findPushTaskTargets(PushTask var1);

    private boolean isTerminated(PushTarget pushTarget, LocalDateTime now, long taskEndOfLifeInDays) {
        LocalDateTime startTime = pushTarget.getStartTime();
        if (null == startTime) {
            return false;
        }
        return startTime.plusDays(taskEndOfLifeInDays).isBefore(now);
    }

    @Override
    public List<Push> create() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_scene", (Object)this.of().name());
        queryWrapper.eq((Object)"status", (Object)1);
        List pushTasks = this.pushTaskService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)pushTasks)) {
            log.info("\u573a\u666f[{}]\u6ca1\u6709\u9700\u8981\u5904\u7406\u7684\u4efb\u52a1", (Object)this.of().name());
            return Collections.emptyList();
        }
        ArrayList results = Lists.newArrayList();
        for (PushTask pushTask : pushTasks) {
            List<PushTarget> pushTargets = this.findPushTaskTargets(pushTask);
            if (CollectionUtils.isEmpty(pushTargets)) {
                log.debug("PushTask:{} has no target", (Object)pushTask);
                continue;
            }
            List<Push> targetResultList = this.filter(pushTask, pushTargets);
            results.addAll(targetResultList);
        }
        return results;
    }

    private List<Push> filter(PushTask pushTask, List<PushTarget> pushTargets) {
        ArrayList results = Lists.newArrayListWithCapacity((int)pushTargets.size());
        LocalDateTime now = LocalDateTime.now();
        for (PushTarget pushTarget : pushTargets) {
            Long userId = pushTarget.getUserId();
            try {
                if (this.isCheckIfPushOnConditional().booleanValue()) {
                    this.checkIfPushOnConditional(pushTask, pushTarget, now);
                }
                results.add(new Push(pushTask, pushTarget));
            }
            catch (ExceedMaximumLifeTimeException e) {
                log.debug("\u76ee\u6807\uff1a{}\uff0c\u5df2\u7ecf\u8d85\u8fc7\u4e86 {} \u6700\u5927\u63a8\u9001\u65f6\u95f4\uff0c\u4e0d\u518d\u63a8\u9001", (Object)userId, (Object)pushTask.getTaskScene());
            }
            catch (ExceedMaximumCountException e) {
                log.debug("\u76ee\u6807\uff1a{}\uff0c\u5df2\u7ecf\u8d85\u8fc7\u4e86 {} \u6700\u5927\u63a8\u9001\u6b21\u6570\uff0c\u4e0d\u518d\u63a8\u9001", (Object)userId, (Object)pushTask.getTaskScene());
            }
        }
        return results;
    }

    private void checkIfPushOnConditional(PushTask pushTask, PushTarget pushTarget, LocalDateTime now) throws ExceedMaximumLifeTimeException, ExceedMaximumCountException {
        Long currentCount;
        Long days = pushTask.getTaskEndOfLife();
        if (this.isTerminated(pushTarget, now, days)) {
            throw new ExceedMaximumLifeTimeException();
        }
        Integer taskCountRange = pushTask.getTaskCountRange();
        boolean sceneRange = taskCountRange == 2;
        Integer pushMaximumCount = pushTask.getPushMaximumCount();
        Integer pushCycleHours = pushTask.getPushCycleHours();
        Long userId = pushTarget.getUserId();
        KeyGenerator counterKey = TaskRedisKeys.stringPushCount((Object)pushTask.getId(), userId);
        if (sceneRange) {
            counterKey = TaskRedisKeys.stringPushCount((Object)pushTask.getTaskScene(), userId);
        }
        if ((currentCount = (Long)Optional.ofNullable(this.fetcher.fetch(counterKey, Long.class)).orElse(0L)) >= (long)pushMaximumCount.intValue()) {
            throw new ExceedMaximumCountException();
        }
        this.increment(counterKey, pushCycleHours);
    }

    protected void increment(KeyGenerator counterKey, Integer pushCycleHours) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String key = counterKey.generateKey();
            Boolean exists = jedis.exists(key);
            jedis.incr(key);
            if (!exists.booleanValue()) {
                long seconds = Duration.ofHours(pushCycleHours.intValue()).getSeconds();
                jedis.expire(key, seconds);
            }
        }
    }
}

