/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.push.factory.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.lovelink.common.dal.entity.Activity;
import com.bxm.lovelink.common.dal.entity.ActivityRegistration;
import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.service.IActivityRegistrationService;
import com.bxm.lovelink.common.dal.service.IActivityService;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.push.TaskRedisKeys;
import com.bxm.lovelink.common.push.factory.AbstractTimerPushSceneService;
import com.bxm.lovelink.common.push.factory.Push;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ActivityStartTimerPushSceneService
extends AbstractTimerPushSceneService {
    private static final Logger log = LoggerFactory.getLogger(ActivityStartTimerPushSceneService.class);
    private final IActivityService activityService;
    private final IActivityRegistrationService activityRegistrationService;
    private final Fetcher fetcher;

    protected ActivityStartTimerPushSceneService(IPushTaskService pushTaskService, Fetcher fetcher, IActivityService activityService, IActivityRegistrationService activityRegistrationService) {
        super(pushTaskService, fetcher);
        this.activityService = activityService;
        this.activityRegistrationService = activityRegistrationService;
        this.fetcher = fetcher;
    }

    @Override
    protected List<PushTarget> findPushTaskTargets(PushTask pushTask) {
        String taskSceneCustomConfig = pushTask.getTaskSceneCustomConfig();
        int hours = NumberUtils.toInt((String)taskSceneCustomConfig);
        if (hours <= 0) {
            return null;
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(Activity::getActivityStatus, (Object)1);
        ((LambdaQueryWrapper)lambdaQueryWrapper.gt(Activity::getActivityStartTime, (Object)LocalDateTime.now())).le(Activity::getActivityStartTime, (Object)LocalDateTime.now().plusHours(hours));
        List activityList = this.activityService.list((Wrapper)lambdaQueryWrapper);
        List activityIds = activityList.stream().filter(Objects::nonNull).map(Activity::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(activityIds)) {
            return Collections.emptyList();
        }
        List activityRegistrations = this.activityRegistrationService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ActivityRegistration::getActivityId, activityIds)).eq(ActivityRegistration::getStatus, (Object)2));
        if (CollectionUtils.isEmpty((Collection)activityRegistrations)) {
            return Collections.emptyList();
        }
        ArrayList<ActivityRegistration> activityRegistrationList = new ArrayList<ActivityRegistration>();
        for (ActivityRegistration activityRegistration2 : activityRegistrations) {
            String targetId = activityRegistration2.getActivityId() + ":" + activityRegistration2.getUserId();
            KeyGenerator counterKey = TaskRedisKeys.stringPushCount((Object)pushTask.getId(), targetId);
            Long currentCount = (Long)Optional.ofNullable(this.fetcher.fetch(counterKey, Long.class)).orElse(0L);
            if (currentCount >= (long)pushTask.getPushMaximumCount().intValue()) continue;
            activityRegistrationList.add(activityRegistration2);
        }
        return activityRegistrationList.stream().map(activityRegistration -> new PushTarget().setUserId(activityRegistration.getUserId()).addExtend("activityId", activityRegistration.getActivityId())).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> createTemplateParameters(final PushTask pushTask, PushTarget pushTarget) {
        Long activityId = (Long)pushTarget.getExtend().get("activityId");
        final Activity activity = (Activity)this.activityService.getById(activityId);
        return new HashMap<String, Object>(){
            {
                this.put("hour", pushTask.getTaskSceneCustomConfig());
                this.put("activityName", activity.getName());
            }
        };
    }

    @Override
    public PushScene of() {
        return PushScene.ACTIVITY_START;
    }

    @Override
    public void onAfterPostEvent(List<Push> pushList) {
        for (Push push : pushList) {
            PushTarget pushTarget = push.getPushTarget();
            Long activityId = (Long)pushTarget.getExtend().get("activityId");
            Long userId = pushTarget.getUserId();
            PushTask pushTask = push.getPushTask();
            String targetId = activityId + ":" + userId;
            KeyGenerator counterKey = TaskRedisKeys.stringPushCount((Object)pushTask.getId(), targetId);
            String taskSceneCustomConfig = pushTask.getTaskSceneCustomConfig();
            int hours = NumberUtils.toInt((String)taskSceneCustomConfig);
            this.increment(counterKey, hours);
        }
    }

    @Override
    public Boolean isCheckIfPushOnConditional() {
        return false;
    }
}

