/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.lovelink.common.push.factory.impl;

import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.dal.service.IUserService;
import com.bxm.lovelink.common.push.factory.AbstractTimerPushSceneService;
import com.bxm.lovelink.common.push.factory.Push;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class LoveRemindTimerPushSceneService
extends AbstractTimerPushSceneService {
    private final IUserService userService;
    private final Fetcher fetcher;
    private final Updater updater;

    public LoveRemindTimerPushSceneService(IPushTaskService pushTaskService, Fetcher fetcher, IUserService userService, Updater updater) {
        super(pushTaskService, fetcher);
        this.userService = userService;
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public void onAfterPostEvent(List<Push> pushList) {
        this.updater.remove(RedisKeys.userBeLoveCount());
    }

    @Override
    protected List<PushTarget> findPushTaskTargets(PushTask pushTask) {
        final Map resultMap = this.fetcher.hfetchall(RedisKeys.userBeLoveCount(), Integer.class);
        if (resultMap == null || resultMap.isEmpty() || resultMap.size() == 0) {
            return null;
        }
        List userList = this.userService.listByIds(resultMap.keySet());
        return userList.stream().map(new Function<User, PushTarget>(){

            @Override
            public PushTarget apply(User user) {
                return new PushTarget().setUserId(user.getId()).addExtend("beLoveCount", resultMap.get(user.getId().toString()));
            }
        }).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> createTemplateParameters(PushTask pushTask, PushTarget pushTarget) {
        final Integer count = (Integer)pushTarget.getExtend().get("beLoveCount");
        return new HashMap<String, Object>(){
            {
                this.put("beLoveCount", count);
            }
        };
    }

    @Override
    public PushScene of() {
        return PushScene.LOVE_REMIND;
    }
}

